<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$empConso=utf8_decode($_SESSION["empConso"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$txtTitulo=$_GET["txtTitulo"];
$numHoja=$_GET["numHoja"];
$cbFecsn=$_GET["cbFecsn"];
$cbNoFol=$_GET["cbNoFol"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF,$txtTitulo,$numHoja,$cbFecsn,$cbNoFol;
        $func = new functions();
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"C");
        $this->SetFont("Arial","B",9);        
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($txtTitulo." Del ".strftime("%d/%m/%Y", strtotime($dtFecI))." Al ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"C");

        if ($func->stringToBool($cbNoFol)) {
            $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Folio: ".((string)($this->PageNo())+$numHoja)),0,1,"R");
        }
        $this->Ln();
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# QUERYS
$sPolizas = "SELECT * FROM empresas emp LEFT JOIN polizas p ON p.pol_emp=emp.emp_cod LEFT JOIN tipopol tp ON p.pol_tipo=tp.tp_cod WHERE emp_conso='$empConso' AND pol_fec>='$dtFecI' AND pol_fec<='$dtFecF' ORDER BY pol_fec,pol_tipo,pol_ban,pol_num";

function sPoli_det($emp, $dtFec, $selBanCod, $selTipoCod, $numNum, $tipoi) {
    global $empCod;
    return "SELECT * FROM poli_det WHERE pold_emp='$emp' AND pold_fec='$dtFec' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$tipoi'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["polizas"] = $db->query($sPolizas);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['polizas'])) {
    $pdf->SetFont("","B",8);
    $pdf->Cell($lineWidth/8, $lineHeight, utf8_decode("Tipo Poliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/5, $lineHeight, $rec["tp_nom"]);

    $pdf->SetFont("","B",8);
    $pdf->Cell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/5, $lineHeight, $rec["pol_tipo"]."-".$rec["pol_num"]);

    $pdf->SetFont("","B");
    $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Póliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["pol_fec"])),0,1);

    $pdf->SetFont("","B");
    $pdf->Cell($lineWidth/8, $lineHeight, "Concepto: ");
    $pdf->SetFont("");
    $pdf->MultiCell($lineWidth/1.35, $lineHeight, $rec["pol_con"]);
    $pdf->Ln($lineHeight*2);

    $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
    $pdf->SetFont("","B");
    $pdf->SetWidths(array(3,8,3,3));
    $pdf->SetAligns(array("C","C","C","C"));
    $pdf->Row($header, $lineHeight);

    $pdf->SetFont("");
    $pdf->SetAligns(array("L","L","R","R"));
    $debe = 0;
    $haber = 0;

    $select["poli_det"] = $db->query(sPoli_det($rec["pol_emp"],$rec["pol_fec"], $rec["pol_ban"], $rec["pol_tipo"], $rec["pol_num"], $rec["pol_tipoi"]));
    
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
        $body = array(
            $recTbl["pold_cta"],
            $recTbl["pold_ctan"],
            ($recTbl["pold_debe"] != 0) ? $recTbl["pold_debe"] : "",
            ($recTbl["pold_haber"] != 0) ? $recTbl["pold_haber"] : "",
        );
        $pdf->RowBorderHidden($body, $lineHeight);
    }
    $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());

    $pdf->SetAligns(array("","R","R","R"));
    $body = array(
        "",
        "Totales del documento: ",
        number_format($debe,2),
        number_format($haber,2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
    $pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

    $pdf->Ln($lineHeight);

    $totDebe += $debe;
    $totHaber += $haber;
}
$body = array(
    "",
    "Totales Generales: ",
    number_format($totDebe,2),
    number_format($totHaber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Libro Diario").".pdf","I");
?>