<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];
$empNit=utf8_decode($_SESSION['empNit']);

$selMes=$_GET["selMes"];
$selMesNom=$_GET["selMesNom"];
$numAno=$_GET["numAno"];


# QUERYS
$sIva_comp = "SELECT *,
                TRIM(ic.iva_serie) AS iva_serie,
                TRIM(ic.iva_nit) AS iva_nit,
                TRIM(ic.iva_prov) AS iva_prov
            FROM iva_comp ic LEFT JOIN tipoc tc ON ic.iva_tipo=tc.tc_cod 
            WHERE ic.iva_emp='$empCod' AND year(ic.iva_rfec)=$numAno AND month(ic.iva_rfec)=$selMes AND ic.iva_afe='S' 
            ORDER BY ic.iva_emp,ic.iva_fec";

$sIva_ven = "SELECT *,
                TRIM(iv.ivav_serie) AS ivav_serie,
                TRIM(iv.ivav_nit) AS ivav_nit,
                TRIM(iv.ivav_clin) AS ivav_clin
            FROM iva_ven iv LEFT JOIN tipov tv ON iv.ivav_tipo=tv.tv_cod 
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' 
            ORDER BY iv.ivav_emp,iv.ivav_fec";

# EJECUCION DE QUERYS
$db = new dbExec();

$carpeta = 'Asistelibros';
$fichero="Asistelibros/asiste.asl";

if (!file_exists($carpeta)) {
    mkdir($carpeta, 0777, true);
}


$tc="|";

$filenom = fopen("Asistelibros/asiste.asl", "w+");

# CREA EL CICLO PARA EL LISTADO DE MOVIMIENTOS DE COMPRAS
$item=1;
$select["iva_comp"] = $db->query($sIva_comp);
while ($rec = $db->fetchAssoc($select['iva_comp'])) {

    $t1 = $item;
    $t2 = 'C';
    if ($rec["tc_abrev"] == 'FAC') {
      $abrev="FC";
    } else {
      $abrev=trim($rec["tc_abrev"]);
    }

    $t3 = $abrev;
    $t4 = trim($rec["iva_serie"]);
    $t5 = $rec["iva_num"];
    $t6 = strftime("%d/%m/%Y", strtotime($rec["iva_fec"]));
    $t7 = str_replace("-", "", trim($rec["iva_nit"]));
    $t7 = str_replace(".", "", trim($t7));
    $t7 = str_replace("/", "", trim($t7));
    if ($t7 == '') {
        $t7 = 'CF';
    }        
    $t8 = trim($rec["iva_prov"]);
    if ($rec["iva_imp"] == 0.00 && $rec["iva_impre"] == 0.00) {
        $t9 = 'L';
    } else {
        $t9 = 'I';
    }
    $t10 = '';
    if ($rec["iva_tot"] == 0.00 && $rec["iva_iva"] == 0.00 && $rec["iva_sub"] == 0.00) {
        $t11 = 'A';
    } else {
        $t11 = ' ';
    }
    $t12 = '';
    $t13 = 0;
    $t14 = '';
    $t15 = '';
    if (trim($rec["tc_abrev"]) != 'FPC') {
      if (($rec["iva_bien"]+$rec["iva_medi"]+$rec["iva_vehi"]+$rec["iva_acti"]+$rec["iva_comb"]) != 0.00) {
        $t16 = ($rec["iva_bien"]+$rec["iva_medi"]+$rec["iva_vehi"]+$rec["iva_acti"]+$rec["iva_comb"]);
        } else {
        $t16 = 0.00;
      }
      } else {
      $t16 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      if (($rec["iva_imp"]+$rec["iva_impre"]) != 0.00) {
        $t17 = ($rec["iva_tot"]-($rec["iva_serv"]+$rec["iva_bien"]));
        } else {
        $t17 = 0.00;
      }
      } else {
      $t17 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      if ($rec["iva_serv"] != 0.00) {
        $t18 = $rec["iva_serv"];
        } else {
        $t18 = 0.00;
      }
      } else {
      $t18 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      $t19 = '0';
      } else {
      $t19 = '';
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      if ($rec["iva_noafe"] != 0.00) {
        $t20 = $rec["iva_noafe"];
        } else {
        $t20 = 0.00;
      }
      } else {
      $t20 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      $t21 = 0.00;
      } else {
      $t21 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      $t22 = 0.00;
      } else {
      $t22 = 0.00;
    }
    if (trim($rec["tc_abrev"]) != 'FPC') {
      $t23 = 0.00;
      } else {
      $t23 = 0.00;
    }
    $t24 = '';
    $t25 = 0;
    $t26 = 0.00;
    $t27 = 0.00;
    if (trim($rec["iva_peque"]) != 0.00) {
      $t28 = $rec["iva_peque"];
      } else {
      $t28 = 0.00;
    }
    $t29 = 0.00;
    $t30 = 0.00;
    if ($rec["iva_iva"] != 0.00) {
      if (trim($rec["tc_abrev"]) == 'NC') {
        $t31 = $rec["iva_iva"];
        } else {
        $t31 = $rec["iva_iva"];
      }
      } else {
      $t31 = 0.00;
    }
    if ($rec["iva_tot"] != 0.00) {
      if (trim($rec["tc_abrev"]) == 'NC') {
        $t32 = $rec["iva_tot"];
        } else {
        $t32 = $rec["iva_tot"];
      }
      } else {
      $t32 = '';
    }

    $t_fila = (string)($t1).$tc.$t2.$tc.$t3.$tc.$t4.$tc.(string)($t5).$tc.$t6.$tc.$t7.$tc.$t8.$tc.$t9.$tc.(string)($t10).$tc.$t11.$tc.$t12.$tc.(string)($t13).$tc.$t14.$tc.$t15.$tc.(string)($t16).$tc.(string)($t17).$tc.(string)($t18).$tc.$t19.$tc.(string)($t20).$tc.(string)($t21).$tc.(string)($t22).$tc.(string)($t23).$tc.$t24.$tc.(string)($t25).$tc.(string)($t26).$tc.(string)($t27).$tc.(string)($t28).$tc.(string)($t29).$tc.(string)($t30).$tc.(string)($t31).$tc.(string)($t32);

    fwrite($filenom, $t_fila . PHP_EOL);

    $item += 1;
}


# CREA EL CICLO PARA EL LISTADO DE MOVIMIENTOS DE VENTAS
$select["iva_ven"] = $db->query($sIva_ven);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    
    $t1 = $item;
    $t2 = 'V';
    $t3 = trim($rec["tv_codasiste"]);
    $t4 = trim($rec["ivav_serie"]);
    $t5 = $rec["ivav_num"];
    $t6 = strftime("%d/%m/%Y", strtotime($rec["ivav_fec"]));
    $t7 = str_replace("-", "", trim($rec["ivav_nit"]));
    $t7 = str_replace(".", "", trim($t7));
    $t7 = str_replace("/", "", trim($t7));
    if ($t7 == '') {
        $t7 = 'CF';
    }        
    $t8 = trim($rec["ivav_clin"]);
    if ($rec["ivav_exp"] == 0.00 && $rec["ivav_expre"] == 0.00) {
        $t9 = 'L';
    } else {
        $t9 = 'E';
    }
    if ($rec["ivav_exp"] != 0.00 || $rec["ivav_expre"] != 0.00) {
        $t10 = 'BIEN';
    } else {
        $t10 = '';
    }
    if ($rec["ivav_tot"] == 0.00 && $rec["ivav_iva"] == 0.00 && $rec["ivav_sub"] == 0.00) {
        $t11 = 'A';
    } else {
        $t11 = 'E';
    }
    if ($t11 == 'A') {
       $t7 = 'CF';
    }   
    $t12 = '';
    $t13 = 0;
    $t14 = '';
    $t15 = '';
    if (($rec["ivav_bien"]+$rec["ivav_medi"]+$rec["ivav_vehi"]+$rec["ivav_comb"]) != 0.00) {
        $t16 = ($rec["ivav_bien"]+$rec["ivav_medi"]+$rec["ivav_vehi"]+$rec["ivav_comb"]);
        } else {
        $t16 = 0.00;
    }
    if ($t11 == 'A') {
        $t17 = 0.00;
    } else {
        $t17 = 0.00;
    }
    if ($rec["ivav_serv"] != 0.00) {
        $t18 = $rec["iva_serv"];
    } else {
        $t18 = 0.00;
    }
    $t19 = '0';
    if ($rec["ivav_noafe"]+$rec["ivav_exen"] != 0.00) {
        $t20 = $rec["ivav_noafe"]+$rec["ivav_exen"];
    } else {
        $t20 = 0.00;
    }
    if ($rec["ivav_exp"]+$rec["ivav_expre"] != 0.00) {
        $t21 = $rec["ivav_exp"]+$rec["ivav_expre"];
    } else {
        $t21 = 0.00;
    }
    $t22 = 0.00;
    $t23 = 0.00;
    $t24 = '';
    $t25 = 0;
    $t26 = 0.00;
    $t27 = 0.00;
    $t28 = 0.00;
    $t29 = 0.00;
    $t30 = 0.00;
    if ($rec["ivav_iva"] != 0.00) {
      if (trim($rec["tv_codasiste"]) == 'NC') {
        $t31 = $rec["ivav_iva"];
        } else {
        $t31 = $rec["ivav_iva"];
      }
      } else {
      $t31 = 0.00;
    }
    if ($rec["ivav_tot"] != 0.00) {
      if (trim($rec["tv_codasiste"]) == 'NC') {
        $t32 = $rec["ivav_tot"];
        } else {
        $t32 = $rec["ivav_tot"];
      }
      } else {
      $t32 = '';
    }

    $t_fila = (string)($t1).$tc.$t2.$tc.$t3.$tc.$t4.$tc.(string)($t5).$tc.$t6.$tc.$t7.$tc.$t8.$tc.$t9.$tc.(string)($t10).$tc.$t11.$tc.$t12.$tc.(string)($t13).$tc.$t14.$tc.$t15.$tc.(string)($t16).$tc.(string)($t17).$tc.(string)($t18).$tc.$t19.$tc.(string)($t20).$tc.(string)($t21).$tc.(string)($t22).$tc.(string)($t23).$tc.$t24.$tc.(string)($t25).$tc.(string)($t26).$tc.(string)($t27).$tc.(string)($t28).$tc.(string)($t29).$tc.(string)($t30).$tc.(string)($t31).$tc.(string)($t32);
    
    fwrite($filenom, $t_fila . PHP_EOL);

    $item += 1;
}

fclose($filenom);

$texto = file_get_contents("/Asistelibros/asiste.asl"); 
$texto = nl2br(utf8_encode($texto)); 
echo $texto;

if (file_exists($fichero)) {
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="'.basename($fichero).'"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($fichero));
    readfile($fichero);
    exit;
}

exit;
?>