<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');
include_once("../../../php/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuNom=utf8_decode($_SESSION["usuNom"]);

$numNum=$_GET["numNum"];
$selBanCod=$_GET["selBanCod"];
$banNom=$_GET["banNom"];
$ctabCh=$_GET["ctabCh"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numPoli, $numPolf;
    }
    
    function Footer() {
    }
}

# QUERYS
$sCheques = "SELECT *, TRIM(m.mes_nom) AS mes_nom 
        FROM cheques ch LEFT JOIN bancos ban ON ban.ban_emp=ch.ch_emp AND ban.ban_num=ch.ch_ban 
        LEFT JOIN meses m ON month(ch.ch_fec)=m.mes_cod 
        WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_num='$numNum'";

function sPoli_det($selBanCod, $numNum) {
    global $empCod;
    return "SELECT *,
                TRIM(pold_cta) AS pold_cta,
                TRIM(pold_ctan) AS pold_ctan
            FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='004' AND pold_num='$numNum'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cheques"] = $db->query($sCheques);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");   //array(22, 21.60)
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['cheques'])) {
    $anoch=date("Y", strtotime($rec["ch_fec"]));
    $diach=date("d", strtotime($rec["ch_fec"]));

    $func = new functions();

    $valor=$rec["ch_tot"];
    $tcam=$rec["ch_tcam"];
    $valLetras=$func->numLetras($valor,$tcam);

    $pdf->SetMargins(1.2, 1, 2.5);
    $pdf->SetAutoPageBreak(true,.5);
    $pdf->SetFont("Arial","B",20);

    $lineWidth=17;
    $lineHeight=0.6;
//    $img = '../img/LOGO_GIRHSA.jpeg';
//    $pdf->Image($img,1,1,5.6,1.8);

    $pdf->SetFont("","",9);
    $pdf->SetFont("","");
    $pdf->SetY(1.8);
    $pdf->SetX(7);
    $pdf->SetFont("","",9);
    $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("Guatemala, "));
    $pdf->MultiAlignCell($lineWidth/3, $lineHeight, $diach." de ".$rec["mes_nom"]." del ".$anoch);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "***".number_format($rec["ch_tot"],2),0,1,"R");
    $pdf->SetY(2.38);
    $pdf->SetX(6.3);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode(TRIM($rec["ch_bene"])),0,1,"L");
    $pdf->SetY(3.08);
    $pdf->SetX(5.5);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode("*** ".$valLetras." ***"),0,1,"L");
    $pdf->SetY(4.2);
    $pdf->SetX(8.1);
    if ($rec["ch_nego"] == "N") {
        $pdf->SetFont("","B",9);
//        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, "",0,0,"L");
        $pdf->MultiAlignCell($lineWidth/3, $lineHeight, "NO NEGOCIABLE"."            ",0,1,"L");
    } else {
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, " ",0,1,"L");
    }

    $lineHeight=0.4;

    $pdf->Ln($lineHeight*6);

//    $header = array("","Nombre de Cuenta","Debe","Haber");
    $pdf->SetFont("","");
    $pdf->SetWidths(array(3,10.5,3,3));
    $pdf->SetAligns(array("C","C","C","C"));
//    $pdf->Row($header, $lineHeight);

    $pdf->SetFont("");
    $pdf->SetAligns(array("L","L","R","R"));
    $debe = 0;
    $haber = 0;

    $pdf->SetY(7);
    $pdf->SetX(7.2);
    $pdf->SetFont("","",9);
//    $pdf->MultiAlignCell($lineWidth/1.5, $lineHeight, $banNom,0,0,"L");
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, $rec["ch_con"],0,0,"L");
    $pdf->MultiAlignCell($lineWidth/3, $lineHeight, $numNum,0,1,"L");
    $pdf->SetX(1.2);
    $pdf->SetFont("","");
//    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, $ctabCh,0,1,"L");
    $pdf->Ln(2);

    $select["poli_det"] = $db->query(sPoli_det($rec["ch_ban"], $rec["ch_num"]));
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
        $body = array(
            $recTbl["pold_cta"],
            $recTbl["pold_ctan"],
            ($recTbl["pold_debe"] != 0) ? number_format($recTbl["pold_debe"],2) : "",
            ($recTbl["pold_haber"] != 0) ? number_format($recTbl["pold_haber"],2) : "",
        );
        $pdf->RowBorderHidden($body, $lineHeight);
    }

    $pdf->SetAligns(array("","R","R","R"));
    $pdf->line($pdf->GetX()+10.5, $pdf->GetY()+.1, $pdf->GetX()+18.2, $pdf->GetY()+.1);  
    $pdf->line($pdf->GetX()+10.5, $pdf->GetY()+.18, $pdf->GetX()+18.2, $pdf->GetY()+.18);
    $pdf->Ln(.25);
    $body = array(
        "",
        "Totales: ",
        number_format($debe,2),
        number_format($haber,2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    
    $pdf->Ln(1.5);
    $pdf->SetFont("","");
    $pdf->SetX(1.2);


    $pdf->SetFont("","",9);
    $pdf->SetY(18.8);
    $pdf->SetX(1.2);
    $pdf->MultiAlignCell($lineWidth/1.5, $lineHeight, trim($usuNom),0,0,"L");
//    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, "RECIBIDO POR: ________________________",0,1,"L");
//    $pdf->line($pdf->GetX()+2.9, $pdf->GetY(), $pdf->GetX()+10.9, $pdf->GetY());

//    if ($rec["ch_num"] < $numChf) { $pdf->AddPage(); }        
}

$db->close();

$pdf->Output(utf8_decode("Cheques").".pdf","I");

?>