<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxc1010";
$bitMod = "cxc";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'consultarLisAnti':
		echo consultarLisAnti();
		break;

	case 'AsignaAnti':
		echo AsignaAnti();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;


	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$selTipoCod=$_POST['selTipoCod'];
	$txtSerie=$_POST['txtSerie'];
	$numNum=$_POST['numNum'];

    if ($selTipoCod=="500" || $selTipoCod=="510") {
      $tipoPol=$selTipoCod;
    } else {
  	  $tipoPol='010';
  	}

	# QUERYS
	$sDoctoscc = "SELECT
					*,
					c.ciem_stat,
					(cl.cli_cod) AS cli_cod,
					(cl.cli_nom) AS cli_nom,
					(cl.cli_cta) AS cli_cta
				  FROM doctoscc dcc
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(dcc.dc_fec) AND c.ciem_ano=YEAR(dcc.dc_fec) AND c.ciem_emp='$empCod'
				  LEFT JOIN cliencc cl ON dcc.dc_emp=cl.cli_emp AND dcc.dc_codp=cl.cli_cod
				  WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_tipo='$selTipoCod'";

	$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_tipoi='$txtSerie' AND pold_num='$numNum'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sDoctoscc, "doctoscc");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArrayEach($resp, array("doctoscc", "poli_det"));
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarClien() {
	global $empCod;
	$txtCodp=utf8_decode($_POST['txtCodp']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nit) AS cli_nit, TRIM(cli_nom) AS cli_nom FROM cliencc WHERE cli_emp='$empCod' and cli_cod='$txtCodp'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "cliencc");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc");
}

function consultarCiemes() {
	global $empCod;

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function consultarLisAnti() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCodp=utf8_decode($_POST['txtCodp']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtClin=utf8_decode($_POST['txtClin']);
	$dtFec=$_POST['dtFec'];
	$dtFecp=$_POST['dtFecp'];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));

	$fecAnt=$_POST['fecAnt'];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crAfe=$_POST['crAfe'];

	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numExen=(empty($_POST['numExen'])) ? 0 : $_POST['numExen'];
	$numExp=(empty($_POST['numExp'])) ? 0 : $_POST['numExp'];
	$numExpre=(empty($_POST['numExpre'])) ? 0 : $_POST['numExpre'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numTfaco=(empty($_POST['numTfaco'])) ? 0 : $_POST['numTfaco'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$numTcam=$_POST['numTcam'];
	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$sube=$_POST['sube'];
	$suber=$_POST['suber'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];
	$deduTot=$_POST['deduTot'];


	$Qbien = $_POST['Qbien'];
	$Qserv = $_POST['Qserv'];
	$Qexen = $_POST['Qexen'];
	$Qexp = $_POST['Qexp'];
	$Qexpre = $_POST['Qexpre'];
	$Qmedi = $_POST['Qmedi'];
	$Qnoafe = $_POST['Qnoafe'];
	$Qtfaco = $_POST['Qtfaco'];
	$Qcomb = $_POST['Qcomb'];
	$Qsubb = $_POST['Qsubb'];
	$Qsubs = $_POST['Qsubs'];
	$Qsubco = $_POST['Qsubco'];
	$Qsubex = $_POST['Qsubex'];
	$Qsube = $_POST['Qsube'];
	$Qsuber = $_POST['Qsuber'];
	$Qsubna = $_POST['Qsubna'];
	$Qsubme = $_POST['Qsubme'];
	$Qret = $_POST['Qret'];
	$Qreti = $_POST['Qreti'];
	$Qsub = $_POST['Qsub'];
	$Qiva = $_POST['Qiva'];
	$Qtot = $_POST['Qtot'];
	$Qdedu =$_POST['Qdedu'];

    $totcp = ($numTot);

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol='010';
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$sAnticpc = "SELECT *, TRIM(tp.tp_abrev) AS tp_abrev FROM anticpc a LEFT JOIN tipopol tp ON a.ant_tipo=tp.tp_cod WHERE ant_emp='$empCod' AND ant_codp='$txtCodp' AND ant_stat='P'";

	$iIva_ven = "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu,ivav_ulcam, ivav_conso, ivav_proco, ivav_mod) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtClin', '$dtFec', '$crRet', '$crReti', '$crAfe', '$Qbien', '$Qserv', '$Qexen', '$Qexp', '$Qexpre', '$Qmedi', '$Qnoafe', '$Qtfaco', '$numGalos', '$numGalor', '$numGalod', '$Qcomb', '$txtCon', '$Qsubb', '$Qsubs', '$Qsubco', '$Qsube', '$Qsuber', '$Qsubna', '$Qsubme', '$Qret', '$Qreti', '$Qsub', '$Qiva', '$Qtot', '$Qdedu', '$usuNom', '$empConso','$txtCodp','cxc')";


	$uIva_ven = "UPDATE iva_ven SET ivav_tipo='$selTipoCod', ivav_clin='$txtClin', ivav_nit='$txtNit', ivav_fec='$dtFec', ivav_retsn='$crRet', ivav_retisn='$crReti', ivav_afe='$crAfe', ivav_bien='$Qbien', ivav_serv='$Qserv', ivav_exen='$Qexen', ivav_exp='$Qexp', ivav_expre='$Qexpre', ivav_medi='$Qmedi', ivav_noafe='$Qnoafe', ivav_tfaco='$Qtfaco', ivav_galos='$numGalos', ivav_galor='$numGalor', ivav_galod='$numGalod', ivav_comb='$Qcomb', ivav_con='$txtCon', ivav_subb='$Qsubb', ivav_subs='$Qsubs', ivav_subco='$Qsubco', ivav_sube='$Qsube', ivav_suber='$Qsuber', ivav_subna='$Qsubna', ivav_subme='$Qsubme', ivav_ret='$Qret', ivav_reti='$Qreti', ivav_sub='$Qsub', ivav_iva='$Qiva', ivav_tot='$Qtot', ivav_dedu='$Qdedu', ivav_ulcam='$usuNom', ivav_conso='$empConso',ivav_proco='$txtCodp', ivav_mod='cxc' WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$sIva_ven = "SELECT * FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$iDoctoscc = "INSERT INTO doctoscc (dc_emp, dc_serie, dc_num, dc_codp, dc_nit, dc_tipo, dc_clien, dc_fec, dc_fecp, dc_retsn, dc_retisn, dc_afe, dc_bien, dc_serv, dc_exen, dc_exp, dc_expre, dc_medi, dc_noafe, dc_tfaco, dc_galos, dc_galor, dc_galod, dc_comb, dc_con, dc_subb, dc_subs, dc_subco, dc_sube, dc_suber, dc_subna, dc_subme, dc_ret, dc_reti, dc_sub, dc_iva, dc_tot, dc_dedu, dc_tcam, dc_ulcam, dc_conso, dc_mod) VALUES ('$empCod', '$txtSerie', '$numNum','$txtCodp', '$txtNit', '$selTipoCod', '$txtClin', '$dtFec', '$dtFecp', '$crRet', '$crReti', '$crAfe', '$numBien', '$numServ', '$numExen', '$numExp', '$numExpre', '$numMedi', '$numNoafe', '$numTfaco', '$numGalos', '$numGalor', '$numGalod', '$numComb', '$txtCon', '$subb', '$subs', '$subco', '$sube', '$suber', '$subna', '$subme', '$numRet', '$numReti', '$numSub', '$numIva', '$numTot', '$deduTot', '$numTcam', '$usuNom', '$empConso','cxc')";

	$uDoctoscc = "UPDATE doctoscc SET dc_tipo='$selTipoCod', dc_codp='$txtCodp', dc_clien='$txtClin', dc_nit='$txtNit', dc_fec='$dtFec', dc_fecp='$dtFecp', dc_retsn='$crRet', dc_retisn='$crReti', dc_afe='$crAfe', dc_bien='$numBien', dc_serv='$numServ', dc_exen='$numExen', dc_exp='$numExp', dc_expre='$numExpre', dc_medi='$numMedi', dc_noafe='$numNoafe', dc_tfaco='$numTfaco', dc_galos='$numGalos', dc_galor='$numGalor', dc_galod='$numGalod', dc_comb='$numComb', dc_con='$txtCon', dc_subb='$subb', dc_subs='$subs', dc_subco='$subco', dc_subve='$subve', dc_sube='$sube', dc_suber='$suber', dc_subna='$subna', dc_subme='$subme', dc_ret='$numRet', dc_reti='$numReti', dc_sub='$numSub', dc_iva='$numIva', dc_tot='$numTot', dc_dedu='$deduTot', dc_tcam='$numTcam', dc_ulcam='$usuNom', dc_conso='$empConso', dc_mod='cxc' WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iClien = "INSERT INTO clien(cli_nit, cli_nom) VALUES ('$txtNit','$txtClin')";

	$uClien = "UPDATE clien SET cli_nom='$txtClin' WHERE cli_nit='$txtNit'";

	$sClien = "select * FROM clien WHERE cli_nit='$txtNit'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	// Primero se graba el documento que esta visualizado
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iDoctoscc);
		$db->query($func->iBitacora(utf8_decode("Se creó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->query($iPolizas);
	} else {
		$resp = $db->uEx($uDoctoscc);
		$select["polizas"] = $db->query($sPolizas);
		($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
		$db->query($func->iBitacora(utf8_decode("Se modificó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));
	}

    $select["iva_ven"] = $db->query($sIva_ven);
	($db->numRows($select["iva_ven"]) > 0) ? $db->uEx($uIva_ven) : $db->iEx($iIva_ven);


    $select["clien"] = $db->query($sClien);
	($db->numRows($select["clien"]) > 0) ? $db->uEx($uClien) : $db->iEx($iClien);

	$db->dEx($dPoli_det);
	if (!$func->jsonEmpty($jsonPol)) {
		$db->iEx($iPoli_det);
	}

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}

	$resp["anticpc"] = $db->sFetchAll($sAnticpc);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sAnticpc;

	return $func->jsonEncodeArray($resp, "anticpc");
}


function AsignaAnti() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipodoc, $txtSerie,$numNum,$txtCod,$txtNit;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$tipodoc=$_POST['tipodoc'];
	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCod=utf8_decode($_POST['txtCod']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$nsaldo=$_POST['nsaldo'];

	$jsonAnti=json_decode($_POST['tblAntiLis']);

	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));


	# QUERYS
	$sDoctoscc = "SELECT dc_emp,dc_serie,dc_num,dc_codp,dc_nit,dc_abo,dc_ret,dc_reti,dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_tipo='$tipodoc' AND dc_serie='$txtSerie' AND dc_num='$numNum'";

	# QUERYS PARA VARIOS REGISTROS
	function sAnticpc($numanti) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "SELECT * FROM anticpc WHERE ant_emp='$empCod' AND ant_num='$numanti'";
	}

	function uAnticpc($numanti) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "UPDATE anticpc SET ant_stat='A' WHERE ant_emp='$empCod' AND ant_num='$numanti'";
	}

	function uDoctoscc($abono,$banco,$tipo,$numero) { 
		global $empCod,$tipodoc,$txtSerie,$numNum,$txtCod,$txtNit;
		return "UPDATE doctoscc SET dc_abo=$abono, dc_ban=$banco, dc_tipodepo='$tipo', dc_numdepo=$numero WHERE dc_emp='$empCod' AND dc_tipo='$tipodoc' AND dc_serie='$txtSerie' AND dc_num='$numNum'";
	}

	function dMovicc($bandepo, $tipodepo, $numdepo) { 
		global $empCod, $usuNom, $tipodoc, $txtSerie,$numNum,$txtCod,$txtNit;
		return "DELETE FROM movicc WHERE mov_emp='$empCod' AND mov_codp='$txtCod' AND mov_ban='$bandepo' AND mov_tipo='$tipodepo' AND mov_num='$numdepo' AND mov_tipoc='$tipodoc' AND mov_seriec='$txtSerie' AND mov_numc='$numNum'";
	}

	function iMovicc($fecdepo, $bandepo, $tipodepo, $numdepo, $aboapli, $tcamdepo) { 
		global $empCod, $usuNom, $tipodoc, $txtSerie,$numNum,$txtCod,$txtNit;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCod','$txtNit','$fecdepo','$tipodepo','$numdepo',$aboapli,'$tipodoc','$txtSerie','$numNum','$bandepo',$tcamdepo)";
	}

	function sMovi($bandepo, $tipodepo, $numdepo) { 
		global $empCod, $usuNom, $txtSerie,$numNum,$txtCod,$txtNit;
		return "SELECT * FROM movi WHERE mov_emp='$empCod' AND mov_ban='$bandepo' AND mov_tipo='$tipodepo' AND mov_num='$numdepo'";
	}

	
	# EJECUCION DE QUERYS
	$db = new dbExec();

	// PARA EL ANTICIPO
	$sientro="N";
	foreach ($jsonAnti as $obj) {
		$numanti = $obj->numdlis;
		$sientro="S";
		$select["anticpc"] = $db->query(sAnticpc($numanti));
		if ($db->numRows($select["anticpc"]) > 0) {
			$fetchAssoc["anticpc"] = $db->fetchAssoc($select["anticpc"]);
			$tipodepo=$fetchAssoc["anticpc"]["ant_tipo"];
			$bandepo=$fetchAssoc["anticpc"]["ant_ban"];
			$numdepo=$fetchAssoc["anticpc"]["ant_ndoc"];
			$sihay='N';
   			$select["movi"] = $db->query(sMovi($bandepo,$tipodepo,$numdepo));
			if ($db->numRows($select["movi"]) > 0) {
				$fetchAssoc["movi"] = $db->fetchAssoc($select["movi"]);
				$valordoc=$fetchAssoc["movi"]["mov_tot"];
				$fecdoc=$fetchAssoc["movi"]["mov_fec"];
				$tcamdoc=$fetchAssoc["movi"]["mov_tcam"];
				$sihay='S';
			} else {
				$valordoc = 0;
			}
			if ($sihay == 'S') {
				$select["doctoscc"] = $db->query($sDoctoscc);
				if ($db->numRows($select["doctoscc"]) > 0) {
					$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);
					$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
					$tcamdc = $fetchAssoc["doctoscc"]["dc_tcam"];
                    if ($tcamdc == 1.000000 && $tcamdoc > 1.000000) {
                       $valordoc = round($valordoc*$tcamdoc,2);
                    }
                    if ($tcamdc > 1.000000 && $tcamdoc == 1.000000) {
                       $valordoc = round($valordoc/$tcamdc,2);
                    }
					if ($nsaldo >= $valordoc) {
						$abonoanti = $valordoc;
					} else {
						$abonoanti = $nsaldo;
					}

					$nvalorabo = ($vAbono+$abonoanti);
					$db->query(uDoctoscc($nvalorabo,$bandepo,$tipodepo,$numdepo));
					$db->query(dMovicc($bandepo,$tipodepo,$numdepo));
					$db->query(iMovicc($fecdoc, $bandepo, $tipodepo, $numdepo, $abonoanti, $tcamdc));
					$db->query(uAnticpc($numanti));
				}		
			}
		}	
	}

	$db->query($func->iBitacora(utf8_decode("Se asigno anticipo a Documento: CxC No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

	$resp = $db->sEx($sDoctoscc, "doctoscc");
	$db->close();
	$func = new functions();
	//$resp["sientro"]=$sientro;
	return $func->jsonEncodeArray($resp, "doctoscc");
}


function generarPartida() {
	global $empCod;
	$numIva=$_POST['numIva'];
	$deduTot=$_POST['deduTot'];
	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numVen=$_POST['numVen'];
	$numServ=$_POST['numServ'];
	$numExport=$_POST['numExport'];
	$ctaCli=$_POST['ctaCli'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaIva"] = ($numIva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
	$resp["ctaComb"] = ($deduTot==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacomb"]));
	$resp["ctaRet"] = ($numRet==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"]));
	$resp["ctaReti"] = ($numReti==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"]));
	$resp["ctaVen"] = ($numVen==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaven"]));
	$resp["ctaServ"] = ($numServ==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaserv"]));
	$resp["ctaExport"] = ($numExport==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaexport"]));
	$resp["ctaCli"] = $db->sFetchAssoc(sCuentas((string)$ctaCli));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaIva');
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $txtSerie, $numNum, $txtCodp, $txtNit;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCodp=utf8_decode($_POST['txtCodp']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtClin=utf8_decode($_POST['txtClin']);
	$dtFec=$_POST['dtFec'];
	$dtFecp=$_POST['dtFecp'];
	$numAno=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));

	$fecAnt=$_POST['fecAnt'];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crAfe=$_POST['crAfe'];

	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numExen=(empty($_POST['numExen'])) ? 0 : $_POST['numExen'];
	$numExp=(empty($_POST['numExp'])) ? 0 : $_POST['numExp'];
	$numExpre=(empty($_POST['numExpre'])) ? 0 : $_POST['numExpre'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numTfaco=(empty($_POST['numTfaco'])) ? 0 : $_POST['numTfaco'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$numTcam=$_POST['numTcam'];
	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$sube=$_POST['sube'];
	$suber=$_POST['suber'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];
	$deduTot=$_POST['deduTot'];


	$Qbien = $_POST['Qbien'];
	$Qserv = $_POST['Qserv'];
	$Qexen = $_POST['Qexen'];
	$Qexp = $_POST['Qexp'];
	$Qexpre = $_POST['Qexpre'];
	$Qmedi = $_POST['Qmedi'];
	$Qnoafe = $_POST['Qnoafe'];
	$Qtfaco = $_POST['Qtfaco'];
	$Qcomb = $_POST['Qcomb'];
	$Qsubb = $_POST['Qsubb'];
	$Qsubs = $_POST['Qsubs'];
	$Qsubco = $_POST['Qsubco'];
	$Qsubex = $_POST['Qsubex'];
	$Qsube = $_POST['Qsube'];
	$Qsuber = $_POST['Qsuber'];
	$Qsubna = $_POST['Qsubna'];
	$Qsubme = $_POST['Qsubme'];
	$Qret = $_POST['Qret'];
	$Qreti = $_POST['Qreti'];
	$Qsub = $_POST['Qsub'];
	$Qiva = $_POST['Qiva'];
	$Qtot = $_POST['Qtot'];
	$Qdedu =$_POST['Qdedu'];

    $totcp = ($numTot);

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

    if ($selTipoCod=="500" || $selTipoCod=="510") {
      $tipoPol=$selTipoCod;
    } else {
  	  $tipoPol='010';
  	}
	
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$iIva_ven = "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu,ivav_ulcam, ivav_conso, ivav_proco, ivav_mod) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtClin', '$dtFec', '$crRet', '$crReti', '$crAfe', '$Qbien', '$Qserv', '$Qexen', '$Qexp', '$Qexpre', '$Qmedi', '$Qnoafe', '$Qtfaco', '$numGalos', '$numGalor', '$numGalod', '$Qcomb', '$txtCon', '$Qsubb', '$Qsubs', '$Qsubco', '$Qsube', '$Qsuber', '$Qsubna', '$Qsubme', '$Qret', '$Qreti', '$Qsub', '$Qiva', '$Qtot', '$Qdedu', '$usuNom', '$empConso','$txtCodp','cxc')";


	$uIva_ven = "UPDATE iva_ven SET ivav_tipo='$selTipoCod', ivav_clin='$txtClin', ivav_nit='$txtNit', ivav_fec='$dtFec', ivav_retsn='$crRet', ivav_retisn='$crReti', ivav_afe='$crAfe', ivav_bien='$Qbien', ivav_serv='$Qserv', ivav_exen='$Qexen', ivav_exp='$Qexp', ivav_expre='$Qexpre', ivav_medi='$Qmedi', ivav_noafe='$Qnoafe', ivav_tfaco='$Qtfaco', ivav_galos='$numGalos', ivav_galor='$numGalor', ivav_galod='$numGalod', ivav_comb='$Qcomb', ivav_con='$txtCon', ivav_subb='$Qsubb', ivav_subs='$Qsubs', ivav_subco='$Qsubco', ivav_sube='$Qsube', ivav_suber='$Qsuber', ivav_subna='$Qsubna', ivav_subme='$Qsubme', ivav_ret='$Qret', ivav_reti='$Qreti', ivav_sub='$Qsub', ivav_iva='$Qiva', ivav_tot='$Qtot', ivav_dedu='$Qdedu', ivav_ulcam='$usuNom', ivav_conso='$empConso',ivav_proco='$txtCodp', ivav_mod='cxc' WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$sIva_ven = "SELECT * FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$iDoctoscc = "INSERT INTO doctoscc (dc_emp, dc_serie, dc_num, dc_codp, dc_nit, dc_tipo, dc_clien, dc_fec, dc_fecp, dc_retsn, dc_retisn, dc_afe, dc_bien, dc_serv, dc_exen, dc_exp, dc_expre, dc_medi, dc_noafe, dc_tfaco, dc_galos, dc_galor, dc_galod, dc_comb, dc_con, dc_subb, dc_subs, dc_subco, dc_sube, dc_suber, dc_subna, dc_subme, dc_ret, dc_reti, dc_sub, dc_iva, dc_tot, dc_dedu, dc_tcam, dc_ulcam, dc_conso, dc_mod) VALUES ('$empCod', '$txtSerie', '$numNum','$txtCodp', '$txtNit', '$selTipoCod', '$txtClin', '$dtFec', '$dtFecp', '$crRet', '$crReti', '$crAfe', '$numBien', '$numServ', '$numExen', '$numExp', '$numExpre', '$numMedi', '$numNoafe', '$numTfaco', '$numGalos', '$numGalor', '$numGalod', '$numComb', '$txtCon', '$subb', '$subs', '$subco', '$sube', '$suber', '$subna', '$subme', '$numRet', '$numReti', '$numSub', '$numIva', '$numTot', '$deduTot', '$numTcam', '$usuNom', '$empConso','cxc')";

	$uDoctoscc = "UPDATE doctoscc SET dc_tipo='$selTipoCod', dc_codp='$txtCodp', dc_clien='$txtClin', dc_nit='$txtNit', dc_fec='$dtFec', dc_fecp='$dtFecp', dc_retsn='$crRet', dc_retisn='$crReti', dc_afe='$crAfe', dc_bien='$numBien', dc_serv='$numServ', dc_exen='$numExen', dc_exp='$numExp', dc_expre='$numExpre', dc_medi='$numMedi', dc_noafe='$numNoafe', dc_tfaco='$numTfaco', dc_galos='$numGalos', dc_galor='$numGalor', dc_galod='$numGalod', dc_comb='$numComb', dc_con='$txtCon', dc_subb='$subb', dc_subs='$subs', dc_subco='$subco', dc_subve='$subve', dc_sube='$sube', dc_suber='$suber', dc_subna='$subna', dc_subme='$subme', dc_ret='$numRet', dc_reti='$numReti', dc_sub='$numSub', dc_iva='$numIva', dc_tot='$numTot', dc_dedu='$deduTot', dc_tcam='$numTcam', dc_ulcam='$usuNom', dc_conso='$empConso', dc_mod='cxc' WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$iClien = "INSERT INTO clien(cli_nit, cli_nom) VALUES ('$txtNit','$txtClin')";

	$uClien = "UPDATE clien SET cli_nom='$txtClin' WHERE cli_nit='$txtNit'";

	$sClien = "select * FROM clien WHERE cli_nit='$txtNit'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$tipoPol','$numNum','$txtSerie','$txtNit','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iDoctoscc);
		$db->query($func->iBitacora(utf8_decode("Se creó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));
		if ($selTipoCod!="SALI") {
			$db->query($iPolizas);
		}
	} else {
		$resp = $db->uEx($uDoctoscc);
		if ($selTipoCod!="SALI") {
		  $select["polizas"] = $db->query($sPolizas);
		  ($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
		}
		$db->query($func->iBitacora(utf8_decode("Se modificó venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));
	}
	if ($selTipoCod!="SALI") {
	    $select["iva_ven"] = $db->query($sIva_ven);
		($db->numRows($select["iva_ven"]) > 0) ? $db->uEx($uIva_ven) : $db->iEx($iIva_ven);
	}

    $select["clien"] = $db->query($sClien);
	($db->numRows($select["clien"]) > 0) ? $db->uEx($uClien) : $db->iEx($iClien);

	if ($selTipoCod!="SALI") {
		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}
		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}
		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;

					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		}
	}
	$resp["aaa"]=$sIva_ven;
	$db->close();

	//return json_encode($resp);
	return $func->jsonEncodeArray($resp, "msg");

}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$func = new functions();

	$selTipoCod=utf8_decode($_POST['selTipoCod']);
	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];

	$fecAnt=$_POST['fecAnt'];
	$numAnoAnt=date("Y", strtotime($fecAnt));
	$numMesAnt=date("n", strtotime($fecAnt));

	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol = "010";

	# QUERYS
	$dIva_ven = "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$txtSerie' AND ivav_num='$numNum'";

	$dDoctoscc = "DELETE FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dDoctoscc);
	if ($selTipoCod!="SALI") {
		$db->dEx($dIva_ven);
		$db->dEx($dPolizas);
		$db->dEx($dPoli_det);

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}
	}

	$db->iEx($func->iBitacora(utf8_decode("Se borró venta No.: $numNum Serie: $txtSerie Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}
?>