<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxc1045";
$bitMod = "cxc";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarOrigen':
		echo consultarOrigen();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarLisDocp':
		echo consultarLisDocp();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'anular':
		echo anular();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

    $tipoCod="012.01";
	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];

	# QUERYS
	$sAbonosc = "SELECT *, TRIM(apl.ant_con) AS ant_con, TRIM(cl.cli_nom) AS cli_nom, TRIM(cl.cli_cta)  AS cli_cta, TRIM(cl.cli_ctad) AS cli_ctad 
				 FROM apliantcpc apl 
				 LEFT JOIN cliencc cl ON apl.ant_emp=cl.cli_emp AND apl.ant_codp=cl.cli_cod 
				 WHERE ant_emp='$empCod' AND ant_tipoabo='$selTipoabo' AND ant_num='$numNum'";

	$sAbo_detc = "SELECT * FROM apliantcpc_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sAbonosc, "apliantcpc");
	$resp["apliantcpc_det"] = $db->sFetchAll($sAbo_detc);
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	//return $func->jsonEncodeArrayEach($resp, array('abonos', 'poli_det', 'abo_det'));
	return $func->jsonEncodeArray($resp, 'apliantcpc', 'poli_det', 'apliantcpc_det');
}

function consultarOrigen() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$numNumorigen=$_POST['numNumorigen'];
	$selTipoaboorigen=$_POST['selTaboorigen'];

	# QUERYS
	$sAnticpc = "SELECT *, TRIM(ant.ant_con) AS ant_con, TRIM(cl.cli_nom) AS cli_nom, TRIM(cl.cli_cta)  AS cli_cta, TRIM(cl.cli_ctad) AS cli_ctad 
				 FROM anticpc ant 
				 LEFT JOIN cliencc cl ON ant.ant_emp=cl.cli_emp AND ant.ant_codp=cl.cli_cod 
				 WHERE ant_emp='$empCod' AND ant_tipoabo='$selTipoaboorigen' AND ant_num='$numNumorigen'";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sAnticpc, "anticpc");
	$db->close();

	$func = new functions();
	//return $func->jsonEncodeArrayEach($resp, array('abonos', 'poli_det', 'abo_det'));
	return $func->jsonEncodeArray($resp, 'anticpc');
}

function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selTabo=$_POST['selTabo'];
	# QUERYS
	$sTipoaboc = "SELECT ta_partsn,ta_corr FROM tipoaboc WHERE ta_cod='$selTabo'";
	$sCorrtaboc = "SELECT * FROM corrtaboc WHERE ctab_emp='$empCod' and ctab_tipo='$selTabo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["tipoaboc"] = $db->sFetchAssoc($sTipoaboc);
	$resp["corrtaboc"] = $db->sFetchAssoc($sCorrtaboc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "tipoaboc", "corrtaboc");
}

function consultarClien() {
	global $empCod;
	$txtCodp=utf8_decode($_POST['txtCodp']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nit) AS cli_nit, TRIM(cli_nom) AS cli_nom, TRIM(cli_cta) AS cli_cta FROM cliencc WHERE cli_emp='$empCod' and cli_cod='$txtCodp'";
	
	$sDoctoscc = "SELECT *, TRIM(dc.dc_con) AS dc_con, TRIM(dc.dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc dc LEFT JOIN cliencc cli ON dc.dc_emp=cli.cli_emp and dc.dc_codp=cli.cli_cod WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "cliencc");
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc", "doctoscc");
}

function consultarLisDocp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sDoctoscc = "SELECT dcc.*, TRIM(dcc.dc_con) AS dc_con, TRIM(dcc.dc_clien) AS dc_clien, (dcc.dc_tot-(dcc.dc_ret+dcc.dc_reti+dcc.dc_abo)) AS dc_sal, 0.00 AS dc_abop
		FROM doctoscc dcc 
		WHERE dcc.dc_emp='$empCod' AND dcc.dc_codp='$txtCod' AND (dcc.dc_tot-(dcc.dc_ret+dcc.dc_reti+dcc.dc_abo))>0.00 ORDER BY dc_emp,dc_num";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	//$resp["asdf"]=$sDoctosc;

	return $func->jsonEncodeArray($resp, "doctoscc");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$anuselTipo=$_POST['anuselTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$anuselTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $ctacli, $txtCon, $dtGrabado, $selTabo;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$selBanCod=0;
	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$selTabo=trim($_POST['selTabo']);
	$nuevocorr=$numNum+1;
	$selTipoCod="012.01";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$nitcli=trim($_POST['nitcli']);
	$ctacli=trim($_POST['ctacli']);
	$selTipoaboorigen=trim($_POST['selTaboorigen']);
	$numNumorigen=$_POST['numNumorigen'];
	$dtFecorigen=trim($_POST['dtFecorigen']);
	$tcamorigen=trim($_POST['numTcamorigen']);
	$tipoaboorigena=trim($_POST['taboorigena']);
	$numorigena=(empty($_POST['numorigena'])) ? 0 : $_POST['numorigena'];
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$numTcama=$_POST['numTcama'];
	$crTmonea=$_POST['crTmonea'];
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$numefeca=(empty($_POST['numefeca'])) ? 0 : $_POST['numefeca'];
	$Tcamexp=$_POST['Tcamexp'];
	$Qefec=$_POST['Qefec'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$Qtot=$_POST['Qtot'];
	$acuma=$_POST['acuma'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	//$numTot=round($numBien+$numServ+$numPeque,2);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec;
	# QUERYS PARA UN REGISTRO
	$sCorrtaboc = "SELECT * FROM corrtaboc WHERE ctab_emp='$empCod' AND ctab_tipo='$selTipoabo'";

	$iApliant = "INSERT INTO apliantcpc(ant_emp, ant_tipoabo, ant_num, ant_fec, ant_tot, ant_codp, ant_con, ant_tcam, ant_ulcam, ant_tmone, ant_tipoanti, ant_numanti, ant_fecanti, ant_tcamapli) VALUES ('$empCod','$selTipoabo','$numNum','$dtFec','$numEfec','$txtCodp','$txtCon','$numTcam','$usuNom','$crTmone', '$selTipoaboorigen', '$numNumorigen', '$dtFecorigen', '$tcamorigen')";

	$uApliant = "UPDATE apliantcpc SET ant_fec='$dtFec', ant_tcam='$numTcam', ant_tot='$sumtot', ant_codp='$txtCodp', ant_con='$txtCon', ant_ulcam='$usuNom', ant_tmone='$crTmone', ant_tipoanti='$selTipoaboorigen', ant_numanti='$numNumorigen', ant_fecanti='$dtFecorigen', ant_tcamapli='$tcamorigen' WHERE ant_emp='$empCod' AND ant_tipoabo='$selTipoabo' AND ant_num='$numNum'";


	$uTipoaboc = "UPDATE tipoaboc SET ta_corr=$nuevocorr WHERE ta_cod='$selTipoabo'";
	$uCorrtaboc = "UPDATE corrtaboc SET ctab_corr=$nuevocorr WHERE ctab_emp='$empCod' and ctab_tipo='$selTipoabo'";
	$iCorrtaboc = "INSERT INTO corrtaboc(ctab_emp, ctab_tipo, ctab_corr) VALUES ('$empCod','$selTipoabo','$nuevocorr')";

	function iPolizas($fecha,$banco,$tipo,$numero,$tipoi, $concep) { 
		global $empCod, $usuNom, $txtCodp, $txtCon, $dtGrabado;
		return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado, pol_tipoi, pol_nit) VALUES ('$empCod','$fecha','$banco','$tipo','$numero','$concep','$usuNom','$dtGrabado','$tipoi','$txtCodp')";
	}

	function uPolizas($fecha,$banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "UPDATE polizas SET pol_fec='$fecha', pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}
	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber, pold_tipoi, pold_nit) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber','$selTipoabo', '$txtCodp')".$func->addValues($obj, $jsonPol);
	}

	# QUERYS PARA PARTIDA DE DEPOSITOS Y TRANSFERENCIAS
	function iPoli_detdt($fecha,$banco,$tipo,$numero,$tipoi,$cta,$ctan,$debe,$haber) { 
		global $empCod, $nitcli;
		return "INSERT INTO poli_det(pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber, pold_tipoi,pold_nit) VALUES ('$empCod','$fecha','$banco','$tipo','$numero','$cta','$ctan','$debe','$haber','$tipoi','$nitcli')";
	}


	$iApliant_det = "INSERT INTO apliantcpc_det (abd_emp, abd_tipo, abd_num, abd_codp, abd_nit, abd_tipoc, abd_seriec, abd_numc, abd_sal, abd_abop, abd_tcam, abd_fec, abd_feccd, abd_tmone, abd_pax) VALUES ";
	foreach ($jsonDocp as $obj) {
		$fechao=$obj->fecha;
		$valores=explode("/",$obj->fecha);
		$fecha=$valores[2]."-".$valores[1]."-".$valores[0];
		$iApliant_det = $iApliant_det."('$empCod','$selTipoabo','$numNum','$txtCodp','$nitcli','$obj->tipo','$obj->serie','$obj->numero','$obj->saldo','$obj->abono','$obj->tcam','$dtFec','$fecha','$crTmone','$obj->pax')".$func->addValues($obj, $jsonDocp);
	}

/*	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";    */

	$dApliant_det = "DELETE FROM apliantcpc_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovicc = "DELETE FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovicc($tipod, $seried, $numd, $tcam, $abono) { 
		global $empCod, $usuNom, $selTipoabo, $numNum, $txtCodp, $nitcli, $dtFec, $numTcam;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitcli','$dtFec','$selTipoabo','$numNum',$abono,'$tipod','$seried','$numd',0, $tcam)";
	}

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie, dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function sAnti($tipoanti, $numanti) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT ant_emp, ant_codp, ant_tipoabo, ant_num, ant_tot, ant_totapli FROM anticpc  WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}
	function uAnti($tipoanti, $numanti, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE anticpc SET ant_totapli=$nvalorabo WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	if ($partsn != 'S') {
	  $probpol2="X";	
	  $probpol3="X";	
	}
	$select["corrtaboc"] = $db->query($sCorrtaboc);
	$fetchAssoc["corrtaboc"] = $db->fetchAssoc($select["corrtaboc"]);		
	$actcorr = $fetchAssoc["corrtaboc"]["ctab_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$debe = trim($obj->debe);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		//if ($ctapol == $ctaprov) {
			$probpol2 = "X";
		//}
		//if ($ctapol == $ctaprov && $totQ == $debe) {
			$probpol3 = "X";
		//}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		
		// PARA ACTUALIZAR  DOCUMENTOS DE CARGO
		// PRIMERO RESTA LO ANTERIOR
		$db->query($dMovicc);
		$db->query($dApliant_det);
		foreach ($jsonDocpAnt as $obja) {
			$tipod = trim($obja->abd_tipoc);
			$seried = trim($obja->abd_seriec);
			$numerod = $obja->abd_numc;
			$abonod = $obja->abd_abop;
			$tcamd = $obja->abd_tcam;
			$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
	            if ($tcamd==1 && $tcamc>1) {
	               $abonod=round($abonod/$tcamc,2);
	            }
	            if ($tcamd>1 && $tcamc==1) {
	               $abonod=round($abonod*$tcamd,2);
	            }
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono-$abonod);
				$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
			}		
		}
	    $tlin=1;
		foreach ($jsonDocp as $obj) {
			$tipod = trim($obj->tipo);
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$tcamd = $obj->tcam;
	        if ($tlin==1) {
	            $txtCon=$txtCon." Expedientes: ".TRIM($numerod);
	        } else {
	            $txtCon=$txtCon.", ".TRIM($numerod);
	        }   
	        $tlin=2;

			$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
	            if ($tcamd==1 && $tcamc>1) {
	               $abonod=round($abonod/$tcamc,2);
	            }
	            if ($tcamd>1 && $tcamc==1) {
	               $abonod=round($abonod*$tcamd,2);
	            }
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
				$db->query(iMovicc($tipod,$seried,$numerod,$tcamc,$abonod));
			}		
		}

		// Actualiza lo aplicado a los anticipos
		$select["anticpc"] = $db->query(sAnti($tipoaboorigena, $numorigena));
		if ($db->numRows($select["anticpc"]) > 0) {
			$fetchAssoc["anticpc"] = $db->fetchAssoc($select["anticpc"]);
            $totaplia=$fetchAssoc["anticpc"]["ant_totapli"];
            if ($tcamorigen==1 && $crTmonea=="E") {
			  $nvalorapli = ($totaplia-(round(($numefeca*$numTcama),2)));
            } else {
			  $nvalorapli = ($totaplia-$numefeca);
			}
			$db->query(uAnti($tipoaboorigena,$numorigena,$nvalorapli));
		}		

		$select["anticpc"] = $db->query(sAnti($selTipoaboorigen, $numNumorigen));
		if ($db->numRows($select["anticpc"]) > 0) {
			$fetchAssoc["anticpc"] = $db->fetchAssoc($select["anticpc"]);
            $totaplia=$fetchAssoc["anticpc"]["ant_totapli"];
            if ($tcamorigen==1 && $crTmone=="E") {
			  $nvalorapli = ($totaplia+(round(($numEfec*$numTcam),2)));
            } else {
				$nvalorapli = ($totaplia+$numEfec);
			}
			$db->query(uAnti($selTipoaboorigen, $numNumorigen,$nvalorapli));
		}		

		if ($func->stringToBool($_POST['nuevo'])) {
			if ($db->numRows($select["corrtaboc"]) == 0) {
				$resp = $db->iEx($iCorrtaboc);
			} else {
				if ($numNum == $actcorr || $numNum > $actcorr) {
					$nuevocorr = $numNum+1;
					$resp = $db->uEx($uCorrtaboc);
				}
			}				
			$resp = $db->iEx($iApliant);
			$db->query($iApliant_det);			
			$db->iEx($func->iBitacora(utf8_decode("Se creó en CxC Documento Aplica No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uApliant);
			$db->query($iApliant_det);			
			$db->iEx($func->iBitacora(utf8_decode("Se modificó en CxC Documento Aplica No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		if ($partsn == 'S') {
			$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
			if ($numEfec!=0) {
			   $db->query(iPolizas($dtFec,$selBanCod,$selTipoCod,$numNum,$selTipoabo,$txtCon));
			}
			$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));
			if (!$func->jsonEmpty($jsonPol)) {
				$db->iEx($iPoli_det);
			}

			// PARA REVERTIR LOS CIERRES
			foreach ($jsonPolAnt as $obj) {
				$cta = $obj->pold_cta;
				$numAnioAnt=date("Y", strtotime($obj->pold_fec));
				$numMesAnt=date("n", strtotime($obj->pold_fec));

				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

					$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

					$cta = $ctaActa;
				}
			}

			// PARA APLICAR LOS CIERRES
			foreach ($jsonPol as $obj) {
				$cta = $obj->cta;
				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

						$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$obj->debe;
						$mhaber=$obj->haber;
						$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}

			}
		}
	}
	//$resp["tipoabo"] = $db->query($sTipoabo);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;
	$resp["taafe"]=$taafe;

	//return $func->jsonEncodeArray($resp, "tipoabo");
	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $ctacli, $txtCon, $dtGrabado;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$selTabo=trim($_POST['selTabo']);
	$selBanCod=0;
	$selTipoCod="012.01";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$nitcli=trim($_POST['nitcli']);
	$ctacli=trim($_POST['ctacli']);
	$selTipoaboorigen=trim($_POST['selTaboorigen']);
	$numNumorigen=trim($_POST['numNumorigen']);
	$dtFecorigen=trim($_POST['dtFecorigen']);
	$tcamorigen=$_POST['numTcamorigen'];
	$tipoaboorigena=trim($_POST['taboorigena']);
	$numorigena=(empty($_POST['numorigena'])) ? 0 : $_POST['numorigena'];
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$numTcama=$_POST['numTcama'];
	$crTmonea=$_POST['crTmonea'];
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$numefeca=(empty($_POST['numefeca'])) ? 0 : $_POST['numefeca'];
	$Tcamexp=$_POST['Tcamexp'];
	$Qefec=$_POST['Qefec'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$Qtot=$_POST['Qtot'];
	$acuma=$_POST['acuma'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec;

	# QUERYS PARA UN REGISTRO

	$dApliant = "DELETE FROM apliantcpc WHERE ant_emp='$empCod' AND ant_tipoabo='$selTipoabo' AND ant_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	$dApliant_det = "DELETE FROM apliantcpc_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovicc = "DELETE FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";


	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function sAnti($tipoanti, $numanti) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT ant_emp, ant_codp, ant_tipoabo, ant_num, ant_tot, ant_totapli FROM anticpc  WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}
	function uAnti($tipoanti, $numanti, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE anticpc SET ant_totapli=$nvalorabo WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dApliant);
	$db->dEx($dApliant_det);
	$db->dEx($dMovicc);

	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$tipod = trim($obja->abd_tipoc);
		$seried = trim($obja->abd_seriec);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$tcamd = $obja->abd_tcam;
		$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
		if ($db->numRows($select["doctoscc"]) > 0) {
			$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
			$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
            if ($tcamd==1 && $tcamc>1) {
               $abonod=round($abonod/$tcamc,2);
            }
            if ($tcamd>1 && $tcamc==1) {
               $abonod=round($abonod*$tcamd,2);
            }
			$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
		}	
		$pasodoc="SI";
	}

	$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
	$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	// Actualiza lo aplicado a los anticipos
	$select["anticpc"] = $db->query(sAnti($tipoaboorigena, $numorigena));
	if ($db->numRows($select["anticpc"]) > 0) {
		$fetchAssoc["anticpc"] = $db->fetchAssoc($select["anticpc"]);
        $totaplia=$fetchAssoc["anticpc"]["ant_totapli"];
        if ($tcamorigen==1 && $crTmonea=="E") {
		  $nvalorapli = ($totaplia-(round(($numefeca*$numTcama),2)));
        } else {
		  $nvalorapli = ($totaplia-$numefeca);
		}
		$db->query(uAnti($tipoaboorigena,$numorigena,$nvalorapli));
	}		

	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro CxC Documento Tipo Aplica $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}

function anular() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $ctacli, $txtCon, $dtGrabado;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$selTabo=trim($_POST['selTabo']);
	$selBanCod=0;
	$selTipoCod="012.01";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$selTipoaboorigen=trim($_POST['selTaboorigen']);
	$numNumorigen=trim($_POST['numNumorigen']);
	$dtFecorigen=trim($_POST['dtFecorigen']);
	$tcamorigen=$_POST['numTcamorigen'];
	$tipoaboorigena=trim($_POST['taboorigena']);
	$numorigena=(empty($_POST['numorigena'])) ? 0 : $_POST['numorigena'];
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$numTcama=$_POST['numTcama'];
	$crTmonea=$_POST['crTmonea'];
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$numefeca=(empty($_POST['numefeca'])) ? 0 : $_POST['numefeca'];
	$Qefec=$_POST['Qefec'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	//$numTot=round($numBien+$numServ+$numPeque,2);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec;
	$anu='**** ANULADO ****';
	$valcero=0;

	# QUERYS PARA UN REGISTRO

	$uApliant = "UPDATE apliantcpc SET ant_tot=0, ant_con='$anu', ant_ulcam='$usuNom', ant_numanti=0 WHERE ant_emp='$empCod' AND ant_tipoabo='$selTipoabo' AND ant_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}


	# QUERYS PARA VARIOS REGISTROS
	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	$uApliant_det = "UPDATE apliantcpc_det SET abd_abop=$valcero WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$uMovicc = "UPDATE movicc SET mov_abo=$valcero WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function sAnti($tipoanti, $numanti) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT ant_emp, ant_codp, ant_tipoabo, ant_num, ant_tot, ant_totapli FROM anticpc  WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}
	function uAnti($tipoanti, $numanti, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE anticpc SET ant_totapli=$nvalorabo WHERE ant_emp='$empCod' AND ant_tipoabo='$tipoanti' AND ant_num='$numanti'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->anEx($uApliant);
	$db->uEx($uApliant_det);
	$db->uEx($uMovicc);
    
	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$tipod = trim($obja->abd_tipoc);
		$seried = trim($obja->abd_seriec);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$tcamd = $obja->abd_tcam;
		$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
		if ($db->numRows($select["doctoscc"]) > 0) {
			$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
			$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
            if ($tcamd==1 && $tcamc>1) {
               $abonod=round($abonod/$tcamc,2);
            }
            if ($tcamd>1 && $tcamc==1) {
               $abonod=round($abonod*$tcamd,2);
            }
			$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
		}
		$pasodoc="SI";
	}

	$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
	$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	// Actualiza lo aplicado a los anticipos
	$select["anticpc"] = $db->query(sAnti($tipoaboorigena, $numorigena));
	if ($db->numRows($select["anticpc"]) > 0) {
		$fetchAssoc["anticpc"] = $db->fetchAssoc($select["anticpc"]);
        $totaplia=$fetchAssoc["anticpc"]["ant_totapli"];
        if ($tcamorigen==1 && $crTmonea=="E") {
		  $nvalorapli = ($totaplia-(round(($numefeca*$numTcama),2)));
        } else {
		  $nvalorapli = ($totaplia-$numefeca);
		}
		$db->query(uAnti($tipoaboorigena,$numorigena,$nvalorapli));
	}		

	//
	$db->iEx($func->iBitacora(utf8_decode("Se Anulo CxC Documento Tipo Aplicacion $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}


function generarPartida() {
	global $empCod;

	$ctacli=$_POST['ctacli'];
	$ctaclid=$_POST['ctaclid'];
	$Qiva=$_POST['Qiva'];
	$numIva=$_POST['numIva'];
	$selTabo=$_POST['selTabo'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$ctaCaja="1110104";
	if ($empCod=="1") {
	  $ctaGancam="5410202";
	} else {
	  $ctaGancam="4110202";
	}
	$ctaPercam="5410102";
	$resp["ctaCli"] = ($ctacli=="") ? "" : $db->sFetchAssoc(sCuentas((string)$ctacli));
	$resp["ctaClid"] = ($ctaclid=="") ? "" : $db->sFetchAssoc(sCuentas((string)$ctaclid));
	$resp["ctaIva"] = ($Qiva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
	$resp["ctaIvac"] = ($selTabo!="003" && $selTabo!="005") ? "" : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaic"]));
	$resp["ctaCaja"] = $db->sFetchAssoc(sCuentas((string)$ctaCaja));
	$resp["ctaGancam"] = $db->sFetchAssoc(sCuentas((string)$ctaGancam));
	$resp["ctaPercam"] = $db->sFetchAssoc(sCuentas((string)$ctaPercam));
	$resp["ctaVen"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaven"]));

	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaCli');
}

?>