<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$crTanti=$_GET["crTanti"];
$txtCodp=$_GET["txtCodp"];
if ($crTanti == 'T') {
    $tipon="TODOS LOS ANTICIPOS";
}
if ($crTanti == 'A') {
    $tipon="ANTICIPOS QUE FUERON YA APLICADOS TOTALMENTE";
}
if ($crTanti == 'P') {
    $tipon="ANTICIPOS CON PENDIENTE DE APLICAR";
}

//$func = new functions();

$lineWidth=21;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFeci, $dtFecf, $tipon;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE ANTICIPOS CxC DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, $tipon,0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $header = array("CODIGO","CLIENTE","TIPO","NUMERO","FECHA","ROE","CONCEPTO","TOTAL","PENDIENTE");
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,6.5,1.8,2,2,1.5,5,2,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","L","C","C","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($crTanti=='T') {
    if ($txtCodp=="ZZZZ" || $txtCodp=="") {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' ORDER BY ant_codp,ant_fec";
    } else {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' AND ant_codp='$txtCodp' ORDER BY ant_codp,ant_fec";
    }
}
if ($crTanti=='A') {
    if ($txtCodp=="ZZZZ" || $txtCodp=="") {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' AND ant_tot<=ant_totapli ORDER BY ant_codp,ant_fec";
    } else {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' AND ant_codp='$txtCodp' AND ant_tot<=ant_totapli ORDER BY ant_codp,ant_fec";
    }
}
if ($crTanti=='P') {
    if ($txtCodp=="ZZZZ" || $txtCodp=="") {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' AND ant_tot>ant_totapli ORDER BY ant_codp,ant_fec";
    } else {
        $sAnti = "SELECT *, TRIM(cli_nom) AS cli_nom, TRIM(ant_con) AS ant_con, TRIM(ta_nom) AS ta_nom 
            FROM anticpc ant
            LEFT JOIN cliencc cli ON ant.ant_emp=cli.cli_emp and ant.ant_codp=cli.cli_cod 
            LEFT JOIN tipoaboc ta ON ant.ant_tipoabo=ta.ta_cod
            WHERE ant_emp='$empCod' and ant_fec>='$dtFeci' and ant_fec<='$dtFecf' AND ant_codp='$txtCodp' AND ant_tot>ant_totapli ORDER BY ant_codp,ant_fec";
    }
}

# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.35;
$select["anticpc"] = $db->query($sAnti);

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$func = new functions();

$ti_clasi="XXXZZZ999";
$tottot=0;
$totpend=0;
$t_lini=1;
$codp="";
$ti_codp="XXZZZ999";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["anticpc"])) {
    $tot=$rec["ant_tot"];
    $apli=$rec["ant_totapli"];
    $pend=$rec["ant_tot"]-$rec["ant_totapli"];

    $tottot += $tot;
    $totpend += ($tot-$apli);

    $body = array(
        $rec["ant_codp"],
        trim($rec["cli_nom"]),
        trim($rec["ta_nom"]),
        $rec["ant_num"],
        strftime("%d/%m/%Y", strtotime($rec["ant_fec"])),
        number_format($rec["ant_tcam"], 6, '.', ','),
        trim($rec["ant_con"]),
        (round($tot, 2) != 0) ? number_format($tot, 2, '.', ',') : "0.00",
        (round($pend, 2) != 0) ? number_format($pend, 2, '.', ',') : "0.00",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 26.2, $pdf->GetY());
$body = array(
    "",
    "",
    "",
    "",
    "",
    "",
    "          TOTAL GENERAL",
    number_format($tottot, 2, '.', ','),
    number_format($totpend, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 26.2, $pdf->GetY());

$pdf->Output(utf8_decode("Lista Anticipos CxC" ).".pdf","I");

$db->close();

?>