<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selClasi=$_GET["selClasi"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec;
        $this->SetMargins(1, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Clientes al ".strftime("%d/%m/%Y")),0,1,"L");

        $this->Ln();
        $this->SetFont("","",7);
        $header = array("Codigo","Nombre Cliente","Nombre Facturar","Direccion","Nit","Telefono","Reti.S/N","D/Cred.","Vendedor");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,4,4,4,2.5,1.8,1.5,1.5,4.5));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","L","L","L","C","R","L"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selClasi=='000') {
    $sCliencc = "SELECT *, TRIM(cli_cod) AS cli_cod, TRIM(vend_nom) AS vend_nom, 
                TRIM(cli_nom) AS cli_nom,
                TRIM(cli_nomfac) AS cli_nomfac,
                TRIM(cli_dir) AS cli_dir,
                TRIM(cli_nit) AS cli_nit,
                TRIM(cli_tel) AS cli_tel,
                TRIM(cli_reti) AS cli_reti 
                FROM cliencc LEFT JOIN clasic ON cliencc.cli_clas=clasic.cla_cod 
                LEFT JOIN vendedor ON cliencc.cli_ven=vendedor.vend_cod
                WHERE cli_emp='$empCod' ORDER BY cli_emp,cli_clas,cli_cod";
} else {
    $sCliencc = "SELECT *, TRIM(cli_cod) AS cli_cod, TRIM(vend_nom) AS vend_nom, 
                TRIM(cli_nom) AS cli_nom,
                TRIM(cli_nomfac) AS cli_nomfac,
                TRIM(cli_dir) AS cli_dir,
                TRIM(cli_nit) AS cli_nit,
                TRIM(cli_tel) AS cli_tel,
                TRIM(cli_reti) AS cli_reti 
                FROM cliencc LEFT JOIN clasic ON cliencc.cli_clas=clasic.cla_cod 
                LEFT JOIN vendedor ON cliencc.cli_ven=vendedor.vend_cod
                WHERE cli_emp='$empCod' AND cli_clas='$selClasi' ORDER BY cli_emp,cli_clas,cli_cod";
}
# EJECUCION DE QUERYS
$db = new dbExec();
$select["cliencc"] = $db->query($sCliencc);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("L","cm", "Letter");
$pdf->AddPage();
$ti_clasi="XXX";
while ($rec = $db->fetchAssoc($select["cliencc"])) {
    if ($ti_clasi!=$rec["cla_cod"]) {
       $pdf->Cell($lineWidth,.7,$rec["cla_nom"],0,0,"L");
       $ti_clasi=$rec["cla_cod"];
       $pdf->ln();
    }
    $body = array(
        $rec["cli_cod"],
        trim($rec["cli_nom"]),
        $rec["cli_nomfac"],
        $rec["cli_dir"],
        $rec["cli_nit"],
        $rec["cli_tel"],
        $rec["cli_reti"],
        $rec["cli_dcre"],
        $rec["vend_nom"],
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Clientes").".pdf","I");
?>