<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */
	/** Error reporting */
	 error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);
	date_default_timezone_set('Europe/London');

	if (PHP_SAPI == 'cli')
		die('This example should only be run from a Web Browser');

	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';
	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel/IOFactory.php';

include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$objPHPExcel = new PHPExcel();

// Esto es para abrir y leer el Excel
$archivo = $_FILES['file']['tmp_name'];
$inputFileType = PHPExcel_IOFactory::identify($archivo);
$objReader = PHPExcel_IOFactory::createReader($inputFileType);
$objPHPExcel = $objReader->load($archivo);

$bitForm = "iva2080";
$bitMod = "iva";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultarCtac':
		echo consultarCtac();
		break;
	case 'guardarCarga':
		echo guardarCarga();
		break;
	case 'borrarCarga':
		echo borrarCarga();
		break;
}

function consultarCtac() {
	global $empCod;
	$txtCtac=utf8_decode($_POST['txtCtac']);

	# QUERYS
	$sCuentas = "SELECT *, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas  WHERE cta='$txtCtac' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}


function guardarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod, $dtGrabado, $objPHPExcel;;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

//	$txtCtac=utf8_decode($_POST['txtCtac']);
//	$crTipov=$_POST['crTipov'];
	$tipoPol='010';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$tbla='';
	$t0=0;
	$mod='iva';


	# QUERYS PARA UN REGISTRO
	function sIva_ven($serie,$num) { 
		global $empCod;
	    return "SELECT * FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$serie' AND ivav_num='$num'";
	}

	function dIva_ven($serie,$num) { 
		global $empCod;
	    return "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$serie' AND ivav_num='$num'";
	}

	function iIva_ven($tipo,$serie,$num,$nit,$clien,$fecha,$numTot,$numBien,$numServ,$numExp,$numIva,$numSubb,$numSubs,$numSube,$numSub,$obs, $ret, $reti, $retsn, $retisn, $tcam, $exen) { 
		global $empCod,$usuNom,$empConso,$selTipoCod,$tbla,$t0;
	    return "INSERT INTO iva_ven (ivav_emp, ivav_serie, ivav_num, ivav_nit, ivav_tipo, ivav_clin, ivav_fec, ivav_retsn, ivav_retisn, ivav_afe, ivav_bien, ivav_serv, ivav_exen, ivav_exp, ivav_expre, ivav_medi, ivav_noafe, ivav_vehi, ivav_vehia, ivav_tvehi, ivav_tfaco, ivav_galos, ivav_galor, ivav_galod, ivav_comb, ivav_con, ivav_subb, ivav_subs, ivav_subco, ivav_subve, ivav_sube, ivav_suber, ivav_subna, ivav_subme, ivav_ret, ivav_reti, ivav_sub, ivav_iva, ivav_tot, ivav_dedu, ivav_ulcam, ivav_conso, ivav_numf, ivav_venrango, ivav_tcam, ivav_proco) VALUES ('$empCod', '$serie', '$num', '$nit', '$tipo', '$clien', '$fecha', '$retsn', '$retisn', 'S', '$numBien', '$numServ', $exen, '$numExp', 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '$obs', '$numSubb', '$numSubs', 0, 0, '$numSube', 0, 0, 0, '$ret', '$reti', '$numSub', '$numIva', '$numTot', 0, '$usuNom', '$empConso', 0, '', '$tcam', '$nit')";
	}

	function iDoctoscc($tipo,$serie,$num,$nit,$clien,$fecha,$numTot,$numBien,$numServ,$numExp,$numIva,$numSubb,$numSubs,$numSube,$numSub,$obs, $ret, $reti, $retsn, $retisn, $tcam, $exen, $codp, $abo) { 
		global $empCod,$usuNom,$empConso,$selTipoCod,$tbla,$t0;
	    return "INSERT INTO doctoscc(dc_emp, dc_fec, dc_serie, dc_num, dc_tipo, dc_nit, dc_clien, dc_bien, dc_serv, dc_peque, dc_exp, dc_tot, dc_sub, dc_subb, dc_subs, dc_sube, dc_subp, dc_iva, dc_stat, dc_afe, dc_con, dc_noafe, dc_conso, dc_ulcam, dc_abo, dc_codp, dc_tcam, dc_totdif, dc_dc, dc_contab, dc_ret, dc_reti, dc_retsn, dc_retisn, dc_sal, dc_abot) VALUES ('$empCod', '$fecha', '$serie', '$num', '$tipo', '$nit', '$clien', '$numBien', '$numServ', '$exen', '$numExp', '$numTot', '$numSub', '$numSubb', '$numSubs', 0, 0, '$numIva', '', 'S', '$obs', 0, '$empCod', '$usuNom', '$abo', '$codp', '$tcam', 0, 0, '', '$ret', '$reti', '$retsn', '$retisn', 0, 0)";
	}

	function sPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "SELECT * FROM poli_det 
	    WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPolizas($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie' AND pol_nit='$nit'";
	}

	function iPolizas($fecha,$serie,$num,$nit,$obs) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$obs','$usuNom','$dtGrabado')";
	}

	function iPoli_det($fecha,$serie,$num,$nit,$cta,$ctan,$debe,$haber) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$cta','$ctan','$debe','$haber')";
	}

	function sClien($nit) { 
		global $empCod;
	    return "SELECT * FROM clien WHERE cli_nit='$nit'";
	}

	function iClien($nit,$clien) { 
		global $empCod;
	    return "INSERT INTO clien(cli_nit, cli_nom, cli_dir, cli_tel, cli_email) VALUES ('$nit','$clien','Ciudad','','')";
	}

	function uClien($nit,$clien) { 
		global $empCod;
	    return "UPDATE clien SET cli_nom='$clien' WHERE cli_nit='$nit'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 
//	$db = new dbExec();

	$pIva = $_SESSION["pIva"];

	$ctaIva = $_SESSION["empCtaiv"];
	$ctaRet = $_SESSION["empCtarisr"];
	$ctaReti = $_SESSION["empCtariva"];

	// Para cargar el archivo desde excel
	// Indicamos que usaremos la primera hoja del excel
	$objPHPExcel->setActiveSheetIndex(0);

	// Revisa cual es la ultima fila y columna trabajada
	$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow(); 
	$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();   
/*
	echo $highestRow;   
	$nom="prueba";
	$resp["fileCompras"]=array();  */
	$resp["fileVentas"]=array();
	$nom="prueba";
	$clien="XXXX999";
	$j=0;
	// Aqui se obtienen los valores de cada celda, hasta el ultimo valor
	for ($row = 2; $clien!=''; $row++){   
		$db = new dbExec();
	//	echo $objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue(); 

		$clien= trim($objPHPExcel->getActiveSheet()->getCell("F".$row)->getValue());
		if ($clien == '') {
			continue;
		}

		$serie= $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue();
		$factura= $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue();
		$fecha1 = $objPHPExcel->getActiveSheet()->getCell("D".$row)->getValue()+1;
		$fecha = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fecha1)); 
		$nit= utf8_decode($objPHPExcel->getActiveSheet()->getCell("E".$row)->getValue());

		$monto= $objPHPExcel->getActiveSheet()->getCell("G".$row)->getValue();
		$montos= $objPHPExcel->getActiveSheet()->getCell("H".$row)->getValue();
		$montoe= $objPHPExcel->getActiveSheet()->getCell("I".$row)->getValue();
		$montoexp= $objPHPExcel->getActiveSheet()->getCell("J".$row)->getValue();
		$ctacar= $objPHPExcel->getActiveSheet()->getCell("K".$row)->getValue();
		$ctacli= $objPHPExcel->getActiveSheet()->getCell("L".$row)->getValue();
		$valcli= $objPHPExcel->getActiveSheet()->getCell("M".$row)->getValue();
		$ctatar= $objPHPExcel->getActiveSheet()->getCell("N".$row)->getValue();
		$valtar= $objPHPExcel->getActiveSheet()->getCell("O".$row)->getValue();
		$ctaven= $objPHPExcel->getActiveSheet()->getCell("P".$row)->getValue();
		$ctaserv= $objPHPExcel->getActiveSheet()->getCell("Q".$row)->getValue();
		$ctaexen= $objPHPExcel->getActiveSheet()->getCell("R".$row)->getValue();
		$ctaexpor= $objPHPExcel->getActiveSheet()->getCell("S".$row)->getValue();
		$reti= $objPHPExcel->getActiveSheet()->getCell("T".$row)->getValue();
		$ret= $objPHPExcel->getActiveSheet()->getCell("U".$row)->getValue();
		$tcam= $objPHPExcel->getActiveSheet()->getCell("V".$row)->getValue();
		$codp= $objPHPExcel->getActiveSheet()->getCell("W".$row)->getValue();		
//		$gravado = $objPHPExcel->getActiveSheet()->getCell("S".$row)->getValue();

		$obs= '';  

		$numMes=date("n", strtotime($fecha));
		$numAno=date("Y", strtotime($fecha));

		if (is_null($monto)) {
			$monto=0;
	    }
		if (is_null($montos)) {
			$montos=0;
	    }
		if (is_null($montoe)) {
			$montoe=0;
	    }
		if (is_null($montoexp)) {
			$montoexp=0;
	    }

		if (is_null($ret)) {
			$ret=0;
	    }
		if (is_null($reti)) {
			$reti=0;
	    }
		if (is_null($ctacar)) {
			$ctacar='';
	    }
		if (is_null($ctacli)) {
			$ctacli='';
	    }
		if (is_null($valcli)) {
			$valcli=0;
	    }
		if (is_null($ctatar)) {
			$ctatar='';
	    }
		if (is_null($valtar)) {
			$valtar=0;
	    }
		if (is_null($ctaven)) {
			$ctaven='';
	    }
		if (is_null($ctaserv)) {
			$ctaserv='';
	    }
		if (is_null($ctaexen)) {
			$ctaexen='';
	    }
		if (is_null($ctaexpor)) {
			$ctaexpor='';
	    }
		if (is_null($tcam)) {
			$tcam=1.0000;
	    }
		if (is_null($codp)) {
			$codp="";
	    }

	    if ($tcam>1) {
	       $montoq=round(($monto*$tcam),2);
		} else {
		   $montoq=$monto;
		}
	    if ($tcam>1) {
	       $montosq=round(($montos*$tcam),2);
		} else {
		   $montosq=$montos;
		}
	    if ($tcam>1) {
	       $montoeq=round(($montoe*$tcam),2);
		} else {
		   $montoeq=$montoe;
		}
	    if ($tcam>1) {
	       $montoexpq=round(($montoexp*$tcam),2);
		} else {
		   $montoexpq=$montoexp;
		}
	    if ($tcam>1) {
	       $montocliq=round(($valcli*$tcam),2);
		} else {
		   $montocliq=$valcli;
		}
	    if ($tcam>1) {
	       $montotarq=round(($valtar*$tcam),2);
		} else {
		   $montotarq=$valtar;
		}

		$tot=0;
		$sub=0;
		$iva=0;
		$subb=0;
		$subs=0;
		$sube=0;
		$bien=0;
		$serv=0;
		$exp=0;
		$exen=0;
		$retsn='N';
		$retisn='N';

		if ($montoq>0) {
			$subb=round(($montoq/(($pIva/100)+1)),2);
			$bien=$montoq;
		}
		if ($montosq>0) {
			$subs=round(($montosq/(($pIva/100)+1)),2);
			$serv=$montosq;
		}
		if ($montoexpq>0) {
			$sube=$montoexpq;
			$exp=$montoexpq;	
		}
		if ($montoeq) {
			$exen=$montoeq;
		}

		$tot=$montoq+$montosq+$montoexpq+$montoeq;
		$sub=round(($subb+$subs+$sube+$exen),2);
		$iva=round(($tot-$sub),2);
		if ($ret>0) {
			$retsn='S';
		}
		if ($reti>0) {
			$retisn='S';
		}

	    // Revisa si ya fue grabado este documento con anterioridad, si es asi, revierte poliza y borra documento
		$select["iva_ven"] = $db->query(sIva_ven($serie,$factura));
		if ($db->numRows($select["iva_ven"]) > 0) {
			// PARA REVERTIR LOS CIERRES
/*			
			$select["poli_det"] = $db->query(sPoli_det($serie,$factura,$nit));
		    while ($recDet = $db->fetchAssoc($select["poli_det"])) {
		        $cta = $recDet["pold_cta"];
		        $debe = $recDet["pold_debe"];
		        $haber = $recDet["pold_haber"];
				$numAnoAnt=date("Y", strtotime($recDet["pold_fec"]));
				$numMesAnt=date("n", strtotime($recDet["pold_fec"]));
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);
					$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$haber;
					$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));
					$cta = $ctaActa;
				}
		    }
*/
		    // Borra el registro de compras y las polizas que le afecten
			$db->query(dIva_ven($serie,$factura));
			$db->query(dPolizas($serie,$factura,$nit));
			$db->query(dPoli_det($serie,$factura,$nit));
		}

		if (strlen($serie)>4) {
		   $tipo="FEL";
		} else {
		   $tipo=$serie;
		}  
		$resp =	$db->query(iIva_ven($tipo,$serie,$factura,$nit,$clien,$fecha,$tot,$bien,$serv,$exp,$iva,$subb,$subs,$sube,$sub,$obs, $ret, $reti, $retsn, $retisn, $tcam, $exen));

		if ($codp!="") {
			$abo=0;
			$db->query(iDoctoscc($tipo,$serie,$factura,$nit,$clien,$fecha,$tot,$bien,$serv,$exp,$iva,$subb,$subs,$sube,$sub,$obs, $ret, $reti, $retsn, $retisn, $tcam, $exen, $codp,$abo));
		}

	    // Revisa si ya existe el proveedor
		$select["clien"] = $db->query(sClien($nit));
		if ($db->numRows($select["clien"]) > 0) {
			$db->query(uClien($nit,$clien));
		} else {
			$db->query(iClien($nit,$clien));
		}

		$resp= $db->query(iPolizas($fecha,$serie,$factura,$nit,$obs));

		// CUENTA DE CARGO
		$cta = $ctacar;
		$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
		$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
		$debe=(($montoq+$montosq+$montoeq+$montoexpq)-($montocliq+$montotarq))-($ret+$reti);
		$haber=0;
		$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
		// PARA APLICAR LOS CIERRES
/*		
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
				$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			} else {
				$mdebe=$debe;
				$mhaber=$haber;
				$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
*/		
		// CUENTA CLIENTES SI EN LA FACTURA HAY VARIAS DIVISIONES
		if ($montocliq > 0) {
			$cta = $ctacli;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$montocliq;
			$haber=0;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA CUANDO PAGAN CON TARJETA DE CREDITO SI EN LA FACTURA HAY VARIAS DIVISIONES
		if ($montotarq > 0) {
			$cta = $ctatar;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$montotarq;
			$haber=0;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA DE RETENCION ISR
		if ($ret > 0) {
			$cta = $ctaRet;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$ret;
			$haber=0;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA DE RETENCION ISR
		if ($reti > 0) {
			$cta = $ctaReti;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$reti;
			$haber=0;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}

		// CUENTA DE IVA
		if ($iva > 0) {
			$cta = $ctaIva;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$iva;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA VENTAS
		if (($subb) > 0) {
			$cta = $ctaven;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$subb;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA SERVICIOS
		if (($subs) > 0) {
			$cta = $ctaserv;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$subs;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA EXPORTACION
		if (($sube) > 0) {
			$cta = $ctaexpor;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$sube;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		// CUENTA EXENTO
		if (($exen) > 0) {
			$cta = $ctaexen;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$exen;
			$db->query(iPoli_det($fecha,$serie,$factura,$nit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
/*			
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
*/			
		}
		$db->close();
	}
	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se creó venta Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function borrarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod, $objPHPExcel;;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$tipoPol='010';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$mod='iva';


	# QUERYS PARA UN REGISTRO
	function sIva_ven($serie,$num) { 
		global $empCod;
	    return "SELECT * FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$serie' AND ivav_num='$num'";
	}

	function dIva_ven($serie,$num) { 
		global $empCod;
	    return "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_serie='$serie' AND ivav_num='$num'";
	}

	function dDoctoscc($serie,$num) { 
		global $empCod;
	    return "DELETE FROM doctoscc WHERE dc_emp='$empCod' AND dc_serie='$serie' AND dc_num='$num'";
	}

	function sPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "SELECT * FROM poli_det 
	    WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPolizas($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie' AND pol_nit='$nit'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 

	// Para cargar el archivo desde excel
	// Indicamos que usaremos la primera hoja del excel
	$objPHPExcel->setActiveSheetIndex(0);

	// Revisa cual es la ultima fila y columna trabajada
	$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow(); 
	$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();   
/*
	echo $highestRow;   
	$nom="prueba";
	$resp["fileCompras"]=array();  */
	$resp["fileVentas"]=array();
	$nom="prueba";
	$clien="XXXX999";
	$j=0;
	// Aqui se obtienen los valores de cada celda, hasta el ultimo valor
	for ($row = 2; $clien!=''; $row++){   
		$db = new dbExec();
	//	echo $objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue(); 

		$clien= trim($objPHPExcel->getActiveSheet()->getCell("F".$row)->getValue());
		if ($clien == '') {
			continue;
		}

		$serie= $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue();
		$factura= $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue();
		$fecha1 = $objPHPExcel->getActiveSheet()->getCell("D".$row)->getValue()+1;
		$fecha = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fecha1)); 
		$nit= $objPHPExcel->getActiveSheet()->getCell("E".$row)->getValue();
/*
		$monto= $objPHPExcel->getActiveSheet()->getCell("G".$row)->getValue();
		$ctacar= $objPHPExcel->getActiveSheet()->getCell("H".$row)->getValue();
		$reti= $objPHPExcel->getActiveSheet()->getCell("I".$row)->getValue();
		$ret= $objPHPExcel->getActiveSheet()->getCell("J".$row)->getValue();
		$tcam= $objPHPExcel->getActiveSheet()->getCell("K".$row)->getValue();
*/

	    // Revisa si ya fue grabado este documento con anterioridad, si es asi, revierte poliza y borra documento
		$select["iva_ven"] = $db->query(sIva_ven($serie,$factura));
		if ($db->numRows($select["iva_ven"]) > 0) {
			// PARA REVERTIR LOS CIERRES
/*			
			$select["poli_det"] = $db->query(sPoli_det($serie,$factura,$nit));
		    while ($recDet = $db->fetchAssoc($select["poli_det"])) {
		        $cta = $recDet["pold_cta"];
		        $debe = $recDet["pold_debe"];
		        $haber = $recDet["pold_haber"];
				$numAnoAnt=date("Y", strtotime($recDet["pold_fec"]));
				$numMesAnt=date("n", strtotime($recDet["pold_fec"]));
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);
					$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$haber;
					$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));
					$cta = $ctaActa;
				}
		    }
*/		    
		    // Borra el registro de ventas, cuentas por cobrar y las polizas que le afecten
			$resp = $db->query(dIva_ven($serie,$factura));
			$db->query(dDoctoscc($serie,$factura));
			$db->query(dPolizas($serie,$factura,$nit));
			$db->query(dPoli_det($serie,$factura,$nit));
		}
		$db->close();
	}
	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se borro Venta, Se habia Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

?>