<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$numAno=$_GET["numAno"];
$selMes=$_GET["selMes"];
$Mesnom=$_GET["Mesnom"];

# QUERYS
$sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, SUM(np_dtra) AS np_sdtra, 
            SUM(np_dsusi) AS np_sdsusi, SUM(np_dvaca) AS np_sdvaca, SUM(np_hsim) AS np_shsim, SUM(np_hdob) AS np_shdob, 
            SUM(np_sord) AS np_ssord, SUM(np_sexts) AS np_ssexts, SUM(np_sextd) AS np_ssextd, SUM(np_boni) AS np_sboni, SUM(np_bonii) AS np_sbonii, SUM(np_bonoe) AS np_sbonoe, SUM(np_depre) AS np_sdepre, SUM(np_viati) AS np_sviati, SUM(np_comi) AS np_scomi,
            SUM(np_otrp) AS np_sotrp, SUM(np_totdev) AS np_stotdev, SUM(np_igss) AS np_sigss,
            SUM(np_isr) AS np_sisr, SUM(np_preb) AS np_spreb, SUM(np_pree) AS np_spree, SUM(np_desj) AS np_sdesj,
            SUM(np_anti) AS np_santi, SUM(np_otrd) AS np_sotrd, SUM(np_unif) AS np_sunif, SUM(np_lent) AS np_slent, SUM(np_totdes) AS np_stotdes, SUM(np_liqrec) AS np_sliqrec,
            TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom,
            mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                WHERE np_emp='$empCod' AND year(np_ffin)='$numAno' AND month(np_ffin)='$selMes' GROUP BY np_emp,np_gru,np_dep ORDER BY np_emp,np_gru,np_dep";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['planilla']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "RESUMEN DE PLANILLAS DEL MES")

            ->setCellValueByColumnAndRow($i, 3, "CORRESPONDIENTE A  ".$Mesnom." DEL ".$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'PROYECTO/DEPARTAMENTO')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO NOMINAL')
            ->setCellValueByColumnAndRow($i++, $j, 'DIAS TRABAJADOS')
            ->setCellValueByColumnAndRow($i++, $j, 'DIAS SUSPENDIDO')
            ->setCellValueByColumnAndRow($i++, $j, 'DIAS VACACIONES')
            ->setCellValueByColumnAndRow($i++, $j, 'HORAS EXTRAS SIMPLES')
            ->setCellValueByColumnAndRow($i++, $j, 'HORAS EXTRAS DOBLES')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO ORDINARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'BONIFICACION LEY')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO EXTRA SIMPLE')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO EXTRA DOBLE')
            ->setCellValueByColumnAndRow($i++, $j, 'BONIF. POR DESEMPEÑO')
            ->setCellValueByColumnAndRow($i++, $j, 'BONO PRODUCTIVIDAD')
            ->setCellValueByColumnAndRow($i++, $j, 'DEPRE.VEHICULO')
            ->setCellValueByColumnAndRow($i++, $j, 'VIATICOS')
            ->setCellValueByColumnAndRow($i++, $j, 'COMISION')
            ->setCellValueByColumnAndRow($i++, $j, 'OTROS INGRESOS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL DEVENGADO')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'ISR')
            ->setCellValueByColumnAndRow($i++, $j, 'ANTICIPO')
            ->setCellValueByColumnAndRow($i++, $j, 'UNIFORME')
            ->setCellValueByColumnAndRow($i++, $j, 'LENTES')
            ->setCellValueByColumnAndRow($i++, $j, 'PRESTAMO BANCO')
            ->setCellValueByColumnAndRow($i++, $j, 'PRESTAMO EMPRESA')
            ->setCellValueByColumnAndRow($i++, $j, 'DESCUENTO JUDICIAL')
            ->setCellValueByColumnAndRow($i++, $j, 'DESCUENTOS VARIOS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL DESCUENTOS')
            ->setCellValueByColumnAndRow($i++, $j, 'LIQUIDO RECIBIR');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    )
 /*,   'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    ) */
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') )
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A5:AC5')->applyFromArray($styEncabezado);
$totdepo=0;
$totch=0;
$grupop=99999;
$depp=99999;
$t_lini=1;
$j=6;
$inidep=6;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode($rec["gru_nom"].", ".$rec["dep_nom"]))
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_snom"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sdtra"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sdsusi"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sdvaca"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_shsim"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_shdob"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_ssord"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sboni"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_ssexts"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_ssextd"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sbonii"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sbonoe"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sdepre"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sviati"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_scomi"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sotrp"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_stotdev"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sigss"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sisr"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_anti"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sunif"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_slent"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_spreb"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_spree"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sdesj"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sotrd"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_stotdes"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sliqrec"]); 
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':AE'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, "           TOTALES")
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(B'.$inidep.':B'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(C'.$inidep.':C'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidep.':D'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidep.':E'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidep.':F'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidep.':G'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(H'.$inidep.':H'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(I'.$inidep.':I'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(M'.$inidep.':M'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(N'.$inidep.':N'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(O'.$inidep.':O'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(P'.$inidep.':P'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q'.$inidep.':Q'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(R'.$inidep.':R'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(S'.$inidep.':S'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(T'.$inidep.':T'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(U'.$inidep.':U'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(V'.$inidep.':V'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(W'.$inidep.':W'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(X'.$inidep.':X'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Y'.$inidep.':Y'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Z'.$inidep.':Z'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AA'.$inidep.':AA'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AB'.$inidep.':AB'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(AC'.$inidep.':AC'.($j-1).')');
    $objPHPExcel->getActiveSheet()->getStyle('B'.$j.':AE'.$j)->applyFromArray($styTotales);
$j+=1;
$inidep=$j;

$j+=1;
$i=$iIni;


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(50);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(15);

$objPHPExcel->getActiveSheet()->getStyle('B6'.':AC'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':A'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])->setTitle('Resumen');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Resumen.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>