<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "fel1040";
$bitMod = "fel";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarLisDocp':
		echo consultarLisDocp();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'anular':
		echo anular();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

    $tipoCod="012";
	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];

	# QUERYS
	$sAbonosc = "SELECT *, TRIM(abo.abo_con) AS abo_con, TRIM(cl.cli_nom) AS cli_nom FROM abonosc abo LEFT JOIN cliencc cl ON abo.abo_emp=cl.cli_emp AND abo.abo_codp=cl.cli_cod WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";
	$sAbo_detc = "SELECT * FROM abo_detc WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sAbonosc, "abonosc");
	$resp["abo_detc"] = $db->sFetchAll($sAbo_detc);
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	//return $func->jsonEncodeArrayEach($resp, array('abonos', 'poli_det', 'abo_det'));
	return $func->jsonEncodeArray($resp, 'abonosc', 'poli_det', 'abo_detc');
}

function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selTabo=$_POST['selTabo'];
	# QUERYS
	$sTipoaboc = "SELECT ta_partsn,ta_corr FROM tipoaboc WHERE ta_cod='$selTabo'";
	$sCorrtaboc = "SELECT * FROM corrtaboc WHERE ctab_emp='$empCod' and ctab_tipo='$selTabo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["tipoaboc"] = $db->sFetchAssoc($sTipoaboc);
	$resp["corrtaboc"] = $db->sFetchAssoc($sCorrtaboc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "tipoaboc", "corrtaboc");
}

function consultarClien() {
	global $empCod;
	$txtCodp=utf8_decode($_POST['txtCodp']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nit) AS cli_nit, TRIM(cli_nom) AS cli_nom, TRIM(cli_cta) AS cli_cta FROM cliencc WHERE cli_emp='$empCod' and cli_cod='$txtCodp'";
	
	$sDoctoscc = "SELECT *, TRIM(dc.dc_con) AS dc_con, TRIM(dc.dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc dc LEFT JOIN cliencc cli ON dc.dc_emp=cli.cli_emp and dc.dc_codp=cli.cli_cod WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "cliencc");
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc", "doctoscc");
}

function consultarLisDocp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sDoctoscc = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCod' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	//$resp["asdf"]=$sDoctosc;

	return $func->jsonEncodeArray($resp, "doctoscc");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$anuselTipo=$_POST['anuselTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$anuselTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $banCtac, $ban2Ctac, $ctacli, $TipoPolDepo, $TipoPolTrans, $txtCon, $dtGrabado, $selBanant, $numNdepoant, $numVdepoant, $selBan2ant, $numNdepo2ant, $numVdepo2ant, $selBan, $selBan2, $numNdepo, $numNdepo2;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$selNomabo=trim($_POST['selNomTabo']);
	$nuevocorr=$numNum+1;
	$selTipoCod="012";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$txtCli=trim(utf8_decode($_POST['txtCli']));
	$nitcli=trim($_POST['nitcli']);
	$ctacli=trim($_POST['ctacli']);
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$crAnti=$_POST['crAnti'];
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$txtNtarj=utf8_decode($_POST['txtNtarj']);
	$numVtarj=(empty($_POST['numVtarj'])) ? 0 : $_POST['numVtarj'];
	$numNch=(empty($_POST['numNch'])) ? 0 : $_POST['numNch'];
	$numVch=(empty($_POST['numVch'])) ? 0 : $_POST['numVch'];
	$numVnc=(empty($_POST['numVnc'])) ? 0 : $_POST['numVnc'];
	$numOtros=(empty($_POST['numOtros'])) ? 0 : $_POST['numOtros'];
	$txtObsotros=$_POST['txtObsotros'];
	$selBan=$_POST['selBan'];
	$Qefec=$_POST['Qefec'];
	$Qvtarj=$_POST['Qvtarj'];
	$Qvch=$_POST['Qvch'];
	$Qvnc=$_POST['Qvnc'];
	$Qotros=$_POST['Qotros'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec+$numVtarj+$numVch+$numVnc+$numOtros;
	$sumtotQ=round($Qefec+$Qvtarj+$Qvch+$Qvnc+$Qotros,2);
    $totQ = $sumtotQ;
    $totivaQ = round($totQ*-1,2);
    $bienivaQ = 0;
    $servivaQ = round($totQ*-1,2);
    $pequeQ = 0;
    $Qsub = ($Qsub*-1);
    $Qsubb = 0;
    $Qsubs = ($Qsub*-1);
    $Qiva = ($Qiva*-1);
    $selBanCod = 0;

	# QUERYS PARA UN REGISTRO
	$sCorrtaboc = "SELECT * FROM corrtaboc WHERE ctab_emp='$empCod' AND ctab_tipo='$selTipoabo'";

	$iAbonosc = "INSERT INTO abonosc(abo_emp, abo_tipo, abo_num, abo_fec, abo_tot, abo_codp, abo_nom, abo_nit, abo_con, abo_tcam, abo_efec, abo_nban, abo_nch, abo_vch, abo_ntarj, abo_vtarj, abo_vnc, abo_otros, abo_obsotros, abo_ulcam, abo_tmone, abo_anti, abo_aplian) VALUES ('$empCod','$selTipoabo','$numNum','$dtFec','$sumtot','$txtCodp','$txtCli','$nitcli','$txtCon','$numTcam','$numEfec','$selBan','$numNch','$numVch','$txtNtarj','$numVtarj','$numVnc','$numOtros','$txtObsotros','$usuNom','$crTmone','$crAnti','N')";

	$uAbonosc = "UPDATE abonosc SET abo_fec='$dtFec', abo_tcam='$numTcam', abo_tot='$sumtot', abo_codp='$txtCodp', abo_nit='$nitcli', abo_con='$txtCon', abo_efec='$numEfec', abo_nban='$selBan', abo_nch='$numNch', abo_vch='$numVch', abo_ntarj='$txtNtarj', abo_vtarj='$numVtarj', abo_vnc='$numVnc', abo_otros='$numOtros', abo_obsotros='$txtObsotros', abo_anti='$crAnti', abo_ulcam='$usuNom', abo_tmone='$crTmone' WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$iIva_ven = "INSERT INTO iva_ven(ivav_emp, ivav_tipo, ivav_serie, ivav_num, ivav_fec, ivav_nit, ivav_clin, ivav_tcam, ivav_tot, ivav_bien, ivav_serv, ivav_sub, ivav_subb, ivav_subs, ivav_iva, ivav_con, ivav_ulcam, ivav_conso, ivav_proco, ivav_mod, ivav_afe) VALUES ('$empCod','$tatrela','$selNomabo','$numNum','$dtFec','$nitcli','$txtCli','$numTcam','$totivaQ', '$bienivaQ','$servivaQ', '$Qsub', '$Qsubb', '$Qsubs', '$Qiva', '$txtCon','$usuNom','$empCod','$txtCodp','cxc','S')";

	$iAnticpc = "INSERT INTO anticpc(ant_emp, ant_tipoaboc, ant_num, ant_fec, ant_codp, ant_tcam, ant_tot, ant_totdif, ant_con, ant_stat,ant_ulcam) VALUES ('$empCod','$selTipoabo','$numNum','$dtFec','$txtCodp','$numTcam','$sumtot', 0,'$txtCon', 'P','$usuNom')";

	$dIva_ven = "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_tipo='$tatrela' AND ivav_num='$numNum'";

	$dAnticpc = "DELETE FROM anticpc WHERE ant_emp='$empCod' AND ant_tipoaboc='$selTipoabo' AND ant_num='$numNum'";

/*	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado, pol_tipoi) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado','$selTipoabo')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'"; */

	$uTipoaboc = "UPDATE tipoaboc SET ta_corr=$nuevocorr WHERE ta_cod='$selTipoabo'";
	$uCorrtaboc = "UPDATE corrtaboc SET ctab_corr=$nuevocorr WHERE ctab_emp='$empCod' and ctab_tipo='$selTipoabo'";
	$iCorrtaboc = "INSERT INTO corrtaboc(ctab_emp, ctab_tipo, ctab_corr) VALUES ('$empCod','$selTipoabo','$nuevocorr')";

	function iPolizas($fecha,$banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCodp, $txtCon, $dtGrabado;
		return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado, pol_tipoi, pol_nit) VALUES ('$empCod','$fecha','$banco','$tipo','$numero','$txtCon','$usuNom','$dtGrabado','$tipoi','$txtCodp')";
	}

	function uPolizas($fecha,$banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "UPDATE polizas SET pol_fec='$fecha', pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}
	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber, pold_tipoi, pold_nit) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber','$selTipoabo', '$txtCodp')".$func->addValues($obj, $jsonPol);
	}


	$iAbo_detc = "INSERT INTO abo_detc (abd_emp, abd_tipo, abd_num, abd_codp, abd_nit, abd_tipoc, abd_seriec, abd_numc, abd_sal, abd_abop, abd_tcam, abd_fec, abd_feccd, abd_tmone) VALUES ";
	foreach ($jsonDocp as $obj) {
		$fechao=$obj->fecha;
		$valores=explode("/",$obj->fecha);
		$fecha=$valores[2]."-".$valores[1]."-".$valores[0];
		$iAbo_detc = $iAbo_detc."('$empCod','$selTipoabo','$numNum','$txtCodp','$nitcli','$obj->tipo','$obj->serie','$obj->numero','$obj->saldo','$obj->abono','$obj->tcam','$dtFec','$fecha','$crTmone')".$func->addValues($obj, $jsonDocp);
	}

/*	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";    */

	$dAbo_detc = "DELETE FROM abo_detc WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovicc = "DELETE FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovicc($tipod, $seried, $numd, $tcam, $abono) { 
		global $empCod, $usuNom, $selTipoabo, $numNum, $txtCodp, $nitcli, $dtFec, $numTcam;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitcli','$dtFec','$selTipoabo','$numNum',$abono,'$tipod','$seried','$numd',0,$tcam)";
	}

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
//	if ($partsn != 'S') {
	  $probpol2="X";	
	  $probpol3="X";	
//	}
	$select["corrtaboc"] = $db->query($sCorrtaboc);
	$fetchAssoc["corrtaboc"] = $db->fetchAssoc($select["corrtaboc"]);		
	$actcorr = $fetchAssoc["corrtaboc"]["ctab_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$debe = trim($obj->debe);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		//if ($ctapol == $ctaprov) {
			$probpol2 = "X";
		//}
		//if ($ctapol == $ctaprov && $totQ == $debe) {
			$probpol3 = "X";
		//}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		
		// PARA ACTUALIZAR  DOCUMENTOS DE CARGO
		// PRIMERO RESTA LO ANTERIOR
		$db->query($dMovicc);
		$db->query($dAbo_detc);
		foreach ($jsonDocpAnt as $obja) {
			$tipod = trim($obja->abd_tipoc);
			$seried = trim($obja->abd_seriec);
			$numerod = $obja->abd_numc;
			$abonod = $obja->abd_abop;
			$tcamd = $obja->abd_tcam;
			$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
	            if ($tcamd==1 && $tcamc>1) {
	               $abonod=round($abonod/$tcamc,2);
	            }
	            if ($tcamd>1 && $tcamc==1) {
	               $abonod=round($abonod*$tcamd,2);
	            }
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono-$abonod);
				$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
			}		
		}
		foreach ($jsonDocp as $obj) {
			$tipod = trim($obj->tipo);
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$tcamd = $obj->tcam;
			$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
	            if ($tcamd==1 && $tcamc>1) {
	               $abonod=round($abonod/$tcamc,2);
	            }
	            if ($tcamd>1 && $tcamc==1) {
	               $abonod=round($abonod*$tcamd,2);
	            }
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
				$db->query(iMovicc($tipod,$seried,$numerod,$tcamc,$abonod));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			if ($db->numRows($select["corrtaboc"]) == 0) {
				$resp = $db->iEx($iCorrtaboc);
			} else {
				if ($numNum == $actcorr || $numNum > $actcorr) {
					$nuevocorr = $numNum+1;
					$resp = $db->uEx($uCorrtaboc);
				}
			}				
			$resp = $db->iEx($iAbonosc);
			$db->query($iAbo_detc);			
			$db->iEx($func->iBitacora(utf8_decode("Se creó en CxC Documento No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uAbonosc);
			$db->query($iAbo_detc);			
			$db->iEx($func->iBitacora(utf8_decode("Se modificó en CxP Documento No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		if ($partsn == 'S') {
			$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
 		    $db->query(iPolizas($dtFec,$selBanCod,$selTipoCod,$numNum,$selTipoabo));
			$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));
			if (!$func->jsonEmpty($jsonPol)) {
				$db->iEx($iPoli_det);
			}

			// PARA REVERTIR LOS CIERRES
			foreach ($jsonPolAnt as $obj) {
				$cta = $obj->pold_cta;
				$numAnioAnt=date("Y", strtotime($obj->pold_fec));
				$numMesAnt=date("n", strtotime($obj->pold_fec));

				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

					$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

					$cta = $ctaActa;
				}
			}

			// PARA APLICAR LOS CIERRES
			foreach ($jsonPol as $obj) {
				$cta = $obj->cta;
				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

						$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$obj->debe;
						$mhaber=$obj->haber;
						$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}

			}
		}
		// Para aplicar la nota de credito en el iva, si es un tipo afecto
		if ($taafe == 'S') {
		   $db->dEx($dIva_ven);
		   $db->iEx($iIva_ven);
		}	
	    $db->dEx($dAnticpc);
		// Para Registrar cuando es anticipo
	    if ($crAnti == 'S') {
		   $db->iEx($iAnticpc);
		}
	}
	//$resp["tipoabo"] = $db->query($sTipoabo);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;
	$resp["taafe"]=$taafe;

	//return $func->jsonEncodeArray($resp, "tipoabo");
	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $banCtac, $ctacli, $txtCon, $dtGrabado, $selBan;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$nuevocorr=$numNum+1;
	$selTipoCod="012";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$txtCli=trim($_POST['txtCli']);
	$nitcli=trim($_POST['nitcli']);
	$ctacli=trim($_POST['ctacli']);
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$crAnti=$_POST['crAnti'];
	$aplian=$_POST['aplian'];	
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$txtNtarj=utf8_decode($_POST['txtNtarj']);
	$numVtarj=(empty($_POST['numVtarj'])) ? 0 : $_POST['numVtarj'];
	$numNch=(empty($_POST['numNch'])) ? 0 : $_POST['numNch'];
	$numVch=(empty($_POST['numVch'])) ? 0 : $_POST['numVch'];
	$numVnc=(empty($_POST['numVnc'])) ? 0 : $_POST['numVnc'];
	$numOtros=(empty($_POST['numOtros'])) ? 0 : $_POST['numOtros'];
	$txtObsotros=$_POST['txtObsotros'];
	$selBan=$_POST['selBan'];
	$Qefec=$_POST['Qefec'];
	$Qvtarj=$_POST['Qvtarj'];
	$Qvch=$_POST['Qvch'];
	$Qvnc=$_POST['Qvnc'];
	$Qotros=$_POST['Qotros'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec+$numVtarj+$numVch+$numVnc+$numOtros;
	$sumtotQ=round($Qefec+$Qvtarj+$Qvch+$Qvnc+$Qotros,2);
    $totQ = $sumtotQ;
    $totivaQ = round($totQ*-1,2);
    $bienivaQ = 0;
    $servivaQ = round($totQ*-1,2);
    $pequeQ = 0;
    $Qsub = ($Qsub*-1);
    $Qsubb = 0;
    $Qsubs = ($Qsub*-1);
    $Qiva = ($Qiva*-1);
	$anu='**** ANULADO ****';
	$valcero=0;
	$selBanCod =0;

	# QUERYS PARA UN REGISTRO

	$dAbonosc = "DELETE FROM  abonosc WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$dIva_ven = "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_tipo='$tatrela' AND ivav_num='$numNum'";

	$dAnticpc = "DELETE FROM anticpc WHERE ant_emp='$empCod' AND ant_tipoaboc='$selTipoabo' AND ant_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	$dAbo_detc = "DELETE FROM abo_detc WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovicc = "DELETE FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	$sMovicc = "SELECT * FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dAbonosc);
	$db->dEx($dAbo_detc);
	$db->dEx($dIva_ven);
	$db->dEx($dAnticpc);
    
	$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
	$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));

	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$tipod = trim($obja->abd_tipoc);
		$seried = trim($obja->abd_seriec);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$tcamd = $obja->abd_tcam;
		$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
		if ($db->numRows($select["doctoscc"]) > 0) {
			$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
			$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
            if ($tcamd==1 && $tcamc>1) {
               $abonod=round($abonod/$tcamc,2);
            }
            if ($tcamd>1 && $tcamc==1) {
               $abonod=round($abonod*$tcamc,2);
            }
			$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
		}		
		$pasodoc="SI";
	}

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	if ($crAnti == 'S' && $aplian == 'S') {
	    $select["movicc"] = $db->query($sMovicc);
		while ($rec = $db->fetchAssoc($select["movicc"])) {
        	$movtipoc=$rec["mov_tipoc"];
        	$movseriec=$rec["mov_seriec"];
        	$movnumc=$rec["mov_numc"];
        	$movabo=$rec["mov_abo"];
			$select["doctoscc"] = $db->query(sDoctoscc($movtipoc, $movseriec, $movnumc));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono-$movabo);
				$db->query(uDoctoscc($movtipoc,$movseriec,$movnumc,$nvalorabo));
			}		
        }
	}

	$db->dEx($dMovicc);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro CxC Documento Tipo $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}

function anular() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr, $banCtac, $ban2Ctac, $ctacli, $txtCon, $dtGrabado, $selBan;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=trim($_POST['selTabo']);
	$nuevocorr=$numNum+1;
	$selTipoCod="012";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$txtCli=trim($_POST['txtCli']);
	$nitcli=trim($_POST['nitcli']);
	$ctacli=trim($_POST['ctacli']);
	$numTcam=$_POST['numTcam'];
	$crTmone=$_POST['crTmone'];
	$crAnti=$_POST['crAnti'];
	$aplian=$_POST['aplian'];
	$txtCon=trim(utf8_decode($_POST['txtCon']));
	$numEfec=(empty($_POST['numEfec'])) ? 0 : $_POST['numEfec'];
	$txtNtarj=utf8_decode($_POST['txtNtarj']);
	$numVtarj=(empty($_POST['numVtarj'])) ? 0 : $_POST['numVtarj'];
	$numNch=(empty($_POST['numNch'])) ? 0 : $_POST['numNch'];
	$numVch=(empty($_POST['numVch'])) ? 0 : $_POST['numVch'];
	$numVnc=(empty($_POST['numVnc'])) ? 0 : $_POST['numVnc'];
	$numOtros=(empty($_POST['numOtros'])) ? 0 : $_POST['numOtros'];
	$txtObsotros=$_POST['txtObsotros'];
	$selBan=$_POST['selBan'];
	$Qefec=$_POST['Qefec'];
	$Qvtarj=$_POST['Qvtarj'];
	$Qvch=$_POST['Qvch'];
	$Qvnc=$_POST['Qvnc'];
	$Qotros=$_POST['Qotros'];
	$Qsub=$_POST['Qsub'];
	$Qiva=$_POST['Qiva'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$sumtot=$numEfec+$numVtarj+$numVch+$numVnc+$numOtros;
	$sumtotQ=round($Qefec+$Qvtarj+$Qvch+$Qvnc+$Qotros,2);
    $totQ = $sumtotQ;
    $totivaQ = round($totQ*-1,2);
    $bienivaQ = 0;
    $servivaQ = round($totQ*-1,2);
    $pequeQ = 0;
    $Qsub = ($Qsub*-1);
    $Qsubb = 0;
    $Qsubs = ($Qsub*-1);
    $Qiva = ($Qiva*-1);
	$anu='**** ANULADO ****';
	$valcero=0;
	$selBanCod = 0;
	# QUERYS PARA UN REGISTRO


	$uAbonosc = "UPDATE abonosc SET abo_tot='$valcero', abo_nom='$anu', abo_con='$anu', abo_efec='$valcero', abo_vtarj='$valcero', abo_vch='$valcero', abo_vnc='$valcero', abo_otros='$valcero', abo_obsotros='', abo_ulcam='$usuNom' WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$dIva_ven = "DELETE FROM iva_ven WHERE ivav_emp='$empCod' AND ivav_tipo='$tatrela' AND ivav_num='$numNum'";

	$uIva_ven = "UPDATE iva_ven SET ivav_tot=0,ivav_sub=0,ivav_subs=0,ivav_subb=0,ivav_serv=0,ivav_bien=0,ivav_iva=0,ivav_peque=0,ivav_exp=0,ivav_sube=0,ivav_exen=0,ivav_clin='$anu' WHERE ivav_emp='$empCod' AND ivav_tipo='$tatrela' AND ivav_num='$numNum'";

	$dAnticpc = "DELETE FROM anticpc WHERE ant_emp='$empCod' AND ant_tipoaboc='$selTipoabo' AND ant_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}


	# QUERYS PARA VARIOS REGISTROS
	function sPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "SELECT *, TRIM(pol_con) AS pol_con FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function sPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod;
		return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	# QUERYS PARA VARIOS REGISTROS
	function dPolizas($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$banco' AND pol_tipo='$tipo' AND pol_num='$numero' AND pol_tipoi='$tipoi'";
	}

	function dPoli_det($banco,$tipo,$numero,$tipoi) { 
		global $empCod, $usuNom, $txtCon, $dtGrabado;
		return "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$banco' AND pold_tipo='$tipo' AND pold_num='$numero' AND pold_tipoi='$tipoi'";
	}

	$uAbo_detc = "UPDATE abo_detc SET abd_abop=$valcero WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$uMovicc = "UPDATE movicc SET mov_abo=$valcero WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	$sMovicc = "SELECT * FROM movicc WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctoscc($tipod, $seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->anEx($uAbonosc);
	$db->uEx($uAbo_detc);
	$db->uEx($uIva_ven);
	$db->uEx($dAnticpc);
    
	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$tipod = trim($obja->abd_tipoc);
		$seried = trim($obja->abd_seriec);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$tcamd = $obja->abd_tcam;
		$select["doctoscc"] = $db->query(sDoctoscc($tipod, $seried, $numerod));
		if ($db->numRows($select["doctoscc"]) > 0) {
			$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
			$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
            if ($tcamd==1 && $tcamc>1) {
               $abonod=round($abonod/$tcamc,2);
            }
            if ($tcamd>1 && $tcamc==1) {
               $abonod=round($abonod*$tcamc,2);
            }
			$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctoscc($tipod,$seried,$numerod,$nvalorabo));
		}		
		$pasodoc="SI";
	}

	$db->dEx(dPolizas($selBanCod,$selTipoCod,$numNum,$selTipoabo));
	$db->dEx(dPoli_det($selBanCod,$selTipoCod,$numNum,$selTipoabo));

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	if ($crAnti == 'S' && $aplian == 'S') {
	    $select["movicc"] = $db->query($sMovicc);
		while ($rec = $db->fetchAssoc($select["movicc"])) {
        	$movtipoc=$rec["mov_tipoc"];
        	$movseriec=$rec["mov_seriec"];
        	$movnumc=$rec["mov_numc"];
        	$movabo=$rec["mov_abo"];
			$select["doctoscc"] = $db->query(sDoctoscc($movtipoc, $movseriec, $movnumc));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);	
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono-$movabo);
				$db->query(uDoctoscc($movtipoc,$movseriec,$movnumc,$nvalorabo));
			}		
        }
	}

	$db->dEx($uMovicc);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Anulo CxC Documento Tipo $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}


function generarPartida() {
	global $empCod;

	$ctacli=$_POST['ctacli'];
	$Qiva=$_POST['Qiva'];
	$crAnti=$_POST['crAnti'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$ctaAnti = "2110206";
	$ctaCajAnti = "1110106";
	if ($crAnti=='S') {
		$resp["ctaCli"] = $db->sFetchAssoc(sCuentas((string)$ctaAnti));
	} else {
		$resp["ctaCli"] = ($ctacli=="") ? "" : $db->sFetchAssoc(sCuentas((string)$ctacli));
	}
	$resp["ctaIva"] = ($Qiva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaiv"]));
//	if ($crAnti=='S') {
		$resp["ctaCaja"] = $db->sFetchAssoc(sCuentas((string)$ctaCajAnti));
//	} else {
//		$resp["ctaCaja"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacaj"]));
//	}
	$resp["ctaVen"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaven"]));
	$resp["ctaAnti"] = $db->sFetchAssoc(sCuentas((string)$ctaAnti));

	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaCli');
}

?>