<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "fel1060";
$bitMod = "fel";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarAnti':
		echo consultarAnti();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod=$_POST['selTipo'];
	$numNum=$_POST['numNum'];

	# QUERYS
	$sPolizas = "SELECT * FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoCod' AND pol_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sPolizas, "polizas");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'polizas');
}

function consultarClien() {
	global $empCod;
	$txtCodp=utf8_decode($_POST['txtCodp']);
    $_SESSION['codClian'] = $txtCodp;

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nit) AS cli_nit, TRIM(cli_nom) AS cli_nom, TRIM(cli_cta) AS cli_cta FROM cliencc WHERE cli_emp='$empCod' and cli_cod='$txtCodp'";
	
	$sDoctoscc = "SELECT *, TRIM(dc.dc_con) AS dc_con, TRIM(dc.dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop, 0 AS dc_noanti FROM doctoscc dc LEFT JOIN cliencc cli ON dc.dc_emp=cli.cli_emp and dc.dc_codp=cli.cli_cod WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00 ORDER BY dc_fec";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "cliencc");
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc", "doctoscc");
}

function consultarAnti() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$selDtipoanti=$_POST['selDtipoanti'];
	$numDnoanti=$_POST['numDnoanti'];

	# QUERYS
	$sAbonosc = "SELECT *
				FROM abonosc
				WHERE abo_emp='$empCod' AND abo_tipo='$selDtipoanti' AND abo_num='$numDnoanti'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["abonosc"] = $db->sFetchAssoc($sAbonosc);
	$db->close();

	$func = new functions();
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'abonosc');
}

function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selBanCod=$_POST['selBanCod'];
	# QUERYS
	$sBancos = "SELECT ban_mon,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bancos"] = $db->sFetchAssoc($sBancos);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "bancos");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$selTipo=$_POST['selTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$selTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitprov, $numTcam, $dtFec, $nitcli;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$nuevocorr=$numNum+1;
	$selTipoCod=$_POST['selTipo'];
	$selBanCod=0;
	$dtFec=$_POST['dtFec'];
	$txtCon=utf8_decode($_POST['txtCon']);
	$txtCodp=utf8_decode($_POST['txtCodp']);
	$nitcli=utf8_decode($_POST['nitcli']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$sCorrpol = "SELECT * FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$selTipoCod'";
	$iCorrpol = "INSERT INTO corrpol (cp_emp,cp_tipo,cp_num) VALUES ('$empCod','$selTipoCod','$nuevocorr')";
	$uCorrpol = "UPDATE corrpol SET cp_num='$nuevocorr' WHERE cp_emp='$empCod' AND cp_tipo='$selTipoCod'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$sDoctosca = "SELECT *, TRIM(dc.dc_con) AS dc_con, TRIM(dc.dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop, 0 AS dc_noanti FROM doctoscc dc LEFT JOIN cliencc cli ON dc.dc_emp=cli.cli_emp and dc.dc_codp=cli.cli_cod WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00 ORDER BY dc_fec";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovicc($tipoanti, $numanti, $fecanti, $tipod, $seried, $numd, $abono) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitcli, $dtFec, $numTcam;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitcli','$fecanti','$tipoanti','$numanti',$abono,'$tipod','$seried','$numd','$selBanCod',1)";
	}

	function sDoctoscc($seried, $numd) { 
		global $empCod, $usuNom, $selBanCod, $txtCodp;
		return "SELECT dc_emp, dc_serie,dc_num, dc_abo FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE doctoscc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function uAbonosc($tipoanti, $numanti) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE abonosc SET abo_aplian='S' WHERE abo_emp='$empCod' AND abo_tipo='$tipoanti' AND abo_num='$numanti'";
	}
	function sAbonosc($tipoanti, $numanti) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "SELECT * FROM abonosc WHERE abo_emp='$empCod' AND abo_tipo='$tipoanti' AND abo_num='$numanti'";
	}

	function dAnticpc($tipoanti, $numanti) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "DELETE FROM anticpc WHERE ant_emp='$empCod' AND ant_tipoaboc='$tipoanti' AND ant_num='$numanti'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="X";	
	$probpol3="X";	

	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		// PARA ACTUALIZAR REGISTRO COMPRAS Y DOCUMENTOS DE CARGO
		foreach ($jsonDocp as $obj) {
			$tipoanti = trim($obj->tipoanti);
			$numanti = trim($obj->noanti);
			$tipod = trim($obj->tipo);
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			if ($numanti==0 || $abonod==0) {
				continue;
			}	
			$select["abonosc"] = $db->query(sAbonosc($tipoanti,$numanti));
			$fetchAssoc["abonosc"] = $db->fetchAssoc($select["abonosc"]);
			$fecanti = $fetchAssoc["abonosc"]["abo_fec"];

			$select["doctoscc"] = $db->query(sDoctoscc($seried,$numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctoscc($seried,$numerod,$nvalorabo));
				$db->query(iMovicc($tipoanti,$numanti,$fecanti,$tipod,$seried,$numerod,$abonod));
				$db->query(dAnticpc($tipoanti,$numanti));
				$db->query(uAbonosc($tipoanti,$numanti));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			$db->iEx($func->iBitacora(utf8_decode("Se creó Poliza Apliacion de Anticipos a Clientes No.: $numNum  Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$db->iEx($func->iBitacora(utf8_decode("Se modificó Poliza Apliacion de Anticipos a Clientes No.: $numNum Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$select["corrpol"] = $db->query($sCorrpol);
		if ($db->numRows($select["corrpol"]) > 0) {
			$db->uEx($uCorrpol);
		} else {
			$db->uEx($iCorrpol);
		}
		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}
	$resp["doctoscc"] = $db->sFetchAll($sDoctosca);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	return $func->jsonEncodeArray($resp, 'doctoscc');
}

function generarPartida() {
	global $empCod;
	$ctacli=$_POST['ctacli'];
	$ctaanti='2110206';

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaAnti"] = $db->sFetchAssoc(sCuentas((string)$ctaanti));
	$resp["ctaCli"] = $db->sFetchAssoc(sCuentas((string)$ctacli));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArrayEach($resp, array('ctaAnti', 'ctaCli'));
}

?>