<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');

$dtFec=date("Y-m-d");
$nAnio=date("Y");
$nMes=date("m");

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];
$usuNom = $_SESSION['usuNom'];

# QUERYS
$sTipoaboc = "SELECT * FROM tipoaboc WHERE ta_otros='S' ORDER BY ta_cod";
$sTipoc = "SELECT * FROM tipoc";
$sMeses = "SELECT * FROM meses";
$sTipopol = "SELECT * FROM tipopol WHERE tp_cod='012.01'";
$sBancos = "SELECT *, 
              TRIM(ban_nom) as ban_nom,
              TRIM(ban_ctab) as ban_ctab,
              TRIM(ban_ctac) as ban_ctac
            FROM bancos WHERE ban_emp='$empCod'";
$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tipoaboc"] = $db->query($sTipoaboc);
$select["tipoc"] = $db->query($sTipoc);
$select["meses"] = $db->query($sMeses);
$select["tipopol"] = $db->query($sTipopol);
$select["bancos"] = $db->query($sBancos);
$mesCerrado = ($db->sFetchAssoc($sCiemes)["ciem_stat"] == "C") ? "true" : "false";
$db->close();
$anoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$mesTrab=date("m", strtotime($_SESSION['empFtrab']));


?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
      ?>

      
      <!-- MODAL CHEQUE -->
      <div class="modal fade" id="modalCheque" tabindex="-1" role="dialog" aria-labelledby="modalChTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-00-tab" data-toggle="pill" href="#pills-00" role="tab" aria-controls="pills-00" aria-selected="true">Registrar Poliza</a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-white" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-00" role="tabpanel" aria-labelledby="pills-00-tab">

                  <form action="" name="thisformCh" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-row">
                      <div class="col-12 col-lg-9 col-xl-10">
                        <div class="form-group">
                          <div class="form-row">
                            <div class="col-md-7">
                              <label for="selTipo">Tipo de Poliza</label>
                              <select class="form-control form-control-sm form-control-as" name="selTipo" id="selTipo">
                                <?php
                                  while ($rec = $db->fetchAssoc($select['tipopol'])) {
                                    echo  '<option value="'.$rec['tp_cod'].'">'.utf8_encode($rec['tp_nom']).'</option>';
                                  }
                                ?>
                              </select>
                            </div>
                            <div class="col-md-4 col-12">
                              <label for="numNum">No. Poliza</label>
                              <input type="number" class="form-control form-control-sm form-control-as font-size-lg" id="numNum" placeholder="0">
                            </div>
                          </div>

                          <div class="form-row align-items-end">
                            <div class="col-6 col-md-3">
                              <label for="dtFec">Fecha Poliza</label>
                              <input type="date" class="form-control form-control-sm form-control-as" id="dtFec" placeholder="">
                            </div>
                          </div>
                          <div class="form-row">
                          </div>
                          <div class="form-row">
                            <div class="col-12">
                              <label for="txtCon">Concepto</label>
                              <textarea class="form-control form-control-sm form-control-as" id="txtCon" rows="2"></textarea>
                            </div>
                          </div>
                        </div>

                        <h3 class="text-light"></h3>

                        <div class="form-group">
                          <div class="form-row">
                            <div class="col-5">
                              <button type="button" class="btn btn-success" id="btnAdd">
                                <i class="fas fa-plus-circle"></i> Agregar
                              </button>
                            </div>
                            <div class="col-7 text-right">
                              <button class="btn btn-primary" id="btnPartida" type="button"><i class="fas fa-poll-h"></i> Generar Partida</button>
                            </div>
                          </div>
                          <h3 class="text-light"></h3>
                          <div class="form-row">
                            <div class="col-md-12">
                              <div class="table-responsive">
                                <table class="table table-hover table-bordered table-dark table-sm" id="tblPol">
                                  <thead>
                                    <tr>
                                      <th scope="col" class="text-center ignore" width="50">ACCIONES</th>
                                      <th scope="col" class="text-center">CUENTA</th>
                                      <th scope="col" class="text-center">DESCRIPCIÓN</th>
                                      <th scope="col" class="text-center">DEBE</th>
                                      <th scope="col" class="text-center">HABER</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                  <tfoot>
                                    <th scope="col" class="ignore"></th>
                                    <th scope="col"></th>
                                    <th scope="col" class="text-right">Totales</th>
                                    <th scope="col" id="dataTotDebe" class="text-right">0.00</th>
                                    <th scope="col" id="dataTotHaber" class="text-right">0.00</th>
                                  </tfoot>
                                </table>
                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="form-group">
                          <div class="form-row">
                          </div>
                        </div>
                      </div>

                      <div class="col-12 col-lg-3 col-xl-2 text-left mt-5">
                        <div class="form-group position-fixed-lg w-lg-3 w-xl-2">
                          <div class="form-row">
                            <div class="col-12 mt-2">
                              <button class="btn btn-success btn-block" id="btnGuardar" type="button">Guardar</button>
                            </div>
                          </div>

                        </div>
                      </div>
                    </div>
                  </form>

                </div>

              </div>

            </div>
          </div>
        </div>
      </div>


      <!-- MODAL POLIZA -->
      <div class="modal fade" id="modalPol" tabindex="-1" role="dialog" aria-labelledby="modalPolTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-000-tab" data-toggle="pill" href="#pills-000" role="tab" aria-controls="pills-000" aria-selected="true"></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" id="pills-001-tab" data-toggle="pill" href="#pills-001" role="tab" aria-controls="pills-001" aria-selected="false">Buscar Cuentas</a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-white" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-000" role="tabpanel" aria-labelledby="pills-000-tab">
                  
                  <form action="" name="" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group">
                      <div class="form-row">
                        <div class="col-md-4">
                          <label for="txtCta">Cuenta</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtCta" placeholder="">
                        </div>
                        <div class="col-md-8">
                          <label for="txtCtaNom">Nombre Cuenta</label>
                          <input type="text" class="form-control form-control-sm form-control-as form-info" id="txtCtaNom" placeholder="" disabled>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="col-md-6">
                          <label for="numDebe">Debe</label>
                          <input type="number" class="form-control form-control-sm form-control-as" id="numDebe" placeholder="0.00">
                        </div>
                        <div class="col-md-6">
                          <label for="numHaber">Haber</label>
                          <input type="number" class="form-control form-control-sm form-control-as" id="numHaber" placeholder="0.00">
                        </div>
                      </div>
                    </div>

                    <button type="button" class="btn btn-success btn-block" id="btnAgregar">Agregar</button>
                    <button type="button" class="btn btn-success btn-block" id="btnModificar">Modificar</button>
                  </form>

                </div>
                <div class="tab-pane fade" id="pills-001" role="tabpanel" aria-labelledby="pills-001-tab">
                  <?php
                    $a='000';
                    $b='001';
                    include('../busCuentasMov/index.html')
                  ?>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>


      <!-- MODAL DOCP -->
      <div class="modal fade" id="modalDocp" tabindex="-1" role="dialog" aria-labelledby="modalDocpTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-006-tab" data-toggle="pill" href="#pills-006" role="tab" aria-controls="pills-006" aria-selected="true"></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" id="pills-007-tab" data-toggle="pill" href="#pills-007" role="tab" aria-controls="pills-007" aria-selected="false">Buscar Anticipos</a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-white" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-006" role="tabpanel" aria-labelledby="pills-006-tab">
                  <form action="" name="" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group">
                      <div class="form-row">
                        <div class="col-4">
                          <label for="txtDserie">Serie</label>
                          <input type="text" class="form-control form-control-md form-control-as" id="txtDserie" disabled>
                        </div>
                        <div class="col-4">
                          <label for="numDnum">Número</label>
                          <input type="number" class="form-control form-control-md form-control-as" id="numDnum" disabled>
                        </div>
                        <div class="col-4">
                          <label for="dtDfec">Fecha</label>
                          <input type="date" class="form-control form-control-md form-control-as" id="dtDfec" disabled>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="col-12">
                          <label for="txtDconcep">Concepto</label>
                          <textarea class="form-control form-control-md form-control-as limpiar" id="txtDconcep" rows="2" disabled></textarea>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="col-6">
                          <label class="font-size-md" for="selDtipoanti">Tipo de Abono</label>
                          <select class="form-control form-control-md form-control-as" name="selDtipoanti" id="selDtipoanti">
                            <?php
                              while ($rec = $db->fetchAssoc($select['tipoaboc'])) {
                                echo  '<option value="'.$rec['ta_cod'].'" data-afe="'.$rec['ta_afe'].'" data-partsn="'.$rec['ta_partsn'].'" data-trela="'.$rec['ta_trela'].'">'.utf8_encode($rec['ta_nom']).'</option>';
                              }
                            ?>
                          </select>
                        </div>
                        <div class="col-6">
                          <label class="font-size-md" for="numDnoanti">Número de Documento</label>
                          <input type="number" class="form-control form-control-md form-control-as" id="numDnoanti" placeholder="0">
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="col-5">
                          <label for="numDsaldo">Saldo del Documento</label>
                          <input type="number" class="form-control form-control-md form-control-as" id="numDsaldo" placeholder="0.00" disabled>
                        </div>
                        <div class="col-5">
                          <label for="numDabono">Abono a Aplicar</label>
                          <input type="number" class="form-control form-control-md form-control-as" id="numDabono" placeholder="0.00">
                        </div>
                      </div>
                    </div>
                    <button type="button" class="btn btn-success btn-block" id="btnModificarDocp">Modificar</button>
                  </form>
                </div>
                <div class="tab-pane fade" id="pills-007" role="tabpanel" aria-labelledby="pills-007-tab">
                  <?php
                    $a='006';
                    $b='007';
                    include('../busAnticc/index.html');
                  ?>
                </div>
              </div>
           </div>
          </div>
        </div>
      </div>

      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Asignar Anticipos</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-1-tab" data-toggle="pill" href="#pills-1" role="tab" aria-controls="pills-1" aria-selected="true">Buscar Clientes</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">

                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-12 col-sm-10">
                      <div class="form-group">
                        <div class="form-row">
                          <div class="col-12 col-sm-6 col-md-3">
                            <label for="txtCodp">Codigo</label>
                            <input type="text" class="form-control form-control-md form-control-as" id="txtCodp" maxlength="20">
                          </div>
                          <div class="col-8">
                            <label for="txtCli">Nombre del Cliente</label>
                            <input type="text" class="form-control form-control-md form-control-as" id="txtCli" maxlength="100" disabled>
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-12 col-sm-6 col-md-3">
                            <label> </label>
                          </div>
                        </div>

                        <div class="form-row">
                          <div class="col-md-12">
                            <div class="table-responsive">
                              <table class="table table-hover table-bordered table-dark table-sm" id="tblDocp">
                                <thead>
                                  <tr>
                                    <th scope="col" class="text-center ignore" width="10">ACCIONES</th>
                                    <th scope="col" class="text-center" width="35">SERIE</th>
                                    <th scope="col" class="text-center" width="35">NÚMERO</th>
                                    <th scope="col" class="text-center" width="25">FEC/DOCTO.</th>
                                    <th scope="col" class="text-center">CONCEPTO</th>
                                    <th scope="col" class="text-center" width="90">SALDO</th>
                                    <th scope="col" class="text-center" width="80">No.ANTICIPO</th>
                                    <th scope="col" class="text-center" width="90">ABONO</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col" class="text-right">Totales</th>
                                  <th scope="col" id="dataTotSal" class="text-right">0.00</th>
                                  <th scope="col"></th>
                                  <th scope="col" id="dataTotAbo" class="text-right">0.00</th>
                                </tfoot>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-12 col-sm-2">
                      <div class="form-group position-fixed-sm">
                        <div class="form-row">
                          <div class="col-12 mt-2">
                            <button class="btn btn-danger btn-block" id="btnRegistraPoliza" type="button">Registrar Poliza</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-primary btn-block" id="btnOtroCli" type="button">Escoger Otro Cliente</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>

              </div>
              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busCliencc/index.html')
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var nuevo = true;
  var totant = 0;
  var nuevoProvee = true;
  var tblDocpAnt;
  var tblPolAnt;
  var usuario = "<?php echo $usuNom ?>";
  var empnom = "<?php echo $empNom ?>";
  var rfecAnt = "0000-00-00";
  var mesCerrado = false;
  var btnAddEdit = "00";
  var inputCtaMov = "txtCta";
  var inputClien = "txtNit"
  var inputCheques = "numNum";
  var inputSelanti = "numNum";
  var inputNoanti = "numNum";

  const txtCodp = document.thisform.txtCodp;
  const txtCli = document.thisform.txtCli;

  const numNum = document.thisformCh.numNum;
  const dtFec = document.thisformCh.dtFec;
  const txtCon = document.thisformCh.txtCon;

  const txtCta = document.getElementById("txtCta");
  const txtCtaNom = document.getElementById("txtCtaNom");
  const numDebe = document.getElementById("numDebe");
  const numHaber = document.getElementById("numHaber");

  const txtCtat = document.getElementById("txtCtat");
  const txtCtatNom = document.getElementById("txtCtatNom");
  const numDebet = document.getElementById("numDebet");
  const numHabert = document.getElementById("numHabert");

  function addRowDocp(tipod, seried, numd, fecd, fecd1, concep, saldo, tipoanti, noanti, abono){
    const row = "<tr>"
                +"<td scope='col' class='ignore'>"
                  +"<div class='btn-group btn-group-sm' role='group' aria-label='Third group'>"
                    +"<button type='button' class='btn btn-primary btn-sm btn-actions' id='btnEditDocp' data-toggle='modal' data-target='#modalDocp'><i class='fas fa-edit'></i></button>"
                  +"</div>"
                +"</td>"
                  +"<td id='datatipod' class='text-left d-none'>"+tipod+"</td>"
                  +"<td id='dataseried' class='text-left'>"+seried+"</td>"
                  +"<td id='datanumd' class='text-left'>"+numd+"</td>"
                  +"<td id='datafecd' class='text-center'>"+YMDToDMY(fecd)+"</td>"
                  +"<td id='datafecd1' class='text-left d-none'>"+fecd1+"</td>"
                  +"<td id='dataconcep' class='text-left'>"+concep+"</td>"
                  +"<td id='datasaldo' class='text-right'>"+saldo+"</td>"
                  +"<td id='datatipoanti' class='text-right d-none'>"+tipoanti+"</td>"
                  +"<td id='datanoanti' class='text-right'>"+noanti+"</td>"
                  +"<td id='dataabono' class='text-right'>"+abono+"</td>"
                +"</tr>";
    $("#tblDocp tbody").append(row);
  }

  sumCaja();

  function sumCaja() {
    var acum = 0;
    var acuma = 0;

    $("#tblDocp").find('tbody tr').each(function () {
      acuma += parseFloat($(this).find('#dataabono').text());
      acum += parseFloat($(this).find('#datasaldo').text());
    });
    $("#tblDocp #dataTotSal").text(acum.toFixed(2));
    $("#tblDocp #dataTotAbo").text(acuma.toFixed(2));
  }

    $("#btnRegistraPoliza").click(function (){
      if ($("#tblDocp #dataTotAbo").text() == 0) {
        alWarning({"msg":{"title":"NO HA ASIGNADO ANTICIPOS","text":"Debe asignar algun anticipo para poder registrar poliza"}});
        return true;
      }
      var tdvacia = true;
      var concepas="";
      var tlinea=0;
      var totpol=0;
      $("#tblDocp tbody tr").each(function(){
        if (!isNullPer($(this).find('#datanoanti').text())) {
          tdvacia = false;
          if (tlinea==0) {
            concepas=concepas+"Anticipo No. "+$(this).find('#datanoanti').text()+" Se aplico al documento: "+$(this).find('#datanumd').text();
            tlinea=1;
          } else {
            concepas=concepas+", Anticipo No. "+$(this).find('#datanoanti').text()+" Se aplico al documento: "+$(this).find('#datanumd').text();
          }
        }
      });
      totpol =  $("#tblDocp #dataTotAbo").text();
      txtCon.value = concepas;
      $('#modalCheque').modal('toggle');
    });

    $("#btnOtroCli").click(function (){
      txtCodp.value = "";
      txtCli.value = "";
      tblClear("tblDocp");
      sumCaja();
      txtCodp.focus();
    });

    // VALID CODIGO
    $("#txtCodp")
    .focus(function() {
      txtCodp.value = "";
      txtCli.value = "";
      tblClear("tblDocp");
      sumCaja();
      inputClien = $(this).attr('id');
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-1-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      const parametros = new FormData();
      parametros.append("action", "consultarClien");
      parametros.append("txtCodp", txtCodp.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevoClien = true;
          } else {
            if (jsonJS.cliencc === null) {
              nuevoClien = true;
              txtCodp.focus();
              txtCli.value = "";
              ctacli="XXXX";
              nitcli="XXXX";
              alWarning({"msg":{"title":"No Existe","text":"Este Cliente no existe, debe registrarlo"}});
               return true;
            } else {
              txtCli.value = jsonJS.cliencc.cli_nom;
              ctacli = jsonJS.cliencc.cli_cta;
              nitcli = jsonJS.cliencc.cli_nit;
              tipoanti = "030";
              jsonJS.doctoscc.forEach(function(i){
                addRowDocp(i.dc_tipo, i.dc_serie, i.dc_num, i.dc_fec, i.dc_fec, i.dc_con, i.dc_sal, tipoanti, i.dc_noanti, i.dc_abop);
              });  
              sumCaja();
              nuevoClien = false;
            }
          }
        }
      });
    });

    // VALID NO ANTICIPO
    $("#selDtipoanti")
    .focus(function() {
      inputSelanti = $(this).attr('id');
    });

    // VALID NO ANTICIPO
    $("#numDnoanti")
    .focus(function() {
      inputNoanti = $(this).attr('id');
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-007-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      const parametros = new FormData();
      parametros.append("action", "consultarAnti");
      parametros.append("selDtipoanti", selDtipoanti.value);
      parametros.append("numDnoanti", numDnoanti.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevoClien = true;
          } else {
            if (jsonJS.abonosc === null) {
              numDnoanti.focus();
              alWarning({"msg":{"title":"No Existe","text":"Este Anticipo no ha sido registrado"}});
               return true;
            } else {
              if (jsonJS.abonosc.abo_anti == 'N') {
                numDnoanti.focus();
                alWarning({"msg":{"title":"NO ES ANTICIPO","text":"Este Documento no esta registrado como Anticipo"}});
                 return true;
              }
              if (jsonJS.abonosc.abo_aplian == 'S') {
                numDnoanti.focus();
                alWarning({"msg":{"title":"YA APLICADO","text":"Este Documento ya fue aplicado a una factura"}});
                 return true;
              }
              numDabono.value = jsonJS.abonosc.abo_tot;
            }
          }
        }
      });
    });


  function restriccion(consultar = false){
    if (!consultar) {
      if (isNullPer(numNum.value)  || numNum.value == 0) {
        numNum.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE CHEQUE"}});
        return true;
      }
      if ($("#dataTotDebe").text() != $("#dataTotHaber").text()) {
        alWarning({"msg":{"title":"Valores Incorrectos","text":"La partida no cuadra, verifique los valores"}});
        return true;
      }
      // PARA VER SI LA PARTIDA ESTÁ VACÍA
/*      if ($("#tblPol tbody").children().length == 0) {
        alWarning({"msg":{"title":"Partida Vacía","text":"Es necesario Generar Partida"}});
        return true;
      }  */
      // RECORRER PARTIDA PARA BUSCAR UNA CUENTA INCORRECTA
      var ctaInc = false;
      var ctaIncBan = true;
      var debInc = false;
      $("#tblPol tbody tr").each(function(){
        if ($(this).find("td:eq(1)").text().includes('XXXX')) { ctaInc = true }
      });
    }
  }

  function restriccionCamposVacios() {
    if (isNullPer(numNum.value)) {
      numNum.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE POLIZA"}});
      return true;
    }
    return false;
  }

  function restriccionMesCerrado() {
    if (mesCerrado) {
      alError({"msg":{"type":"error","title":"Mes Cerrado","text":"No puede trabajar con este mes porque ya fue cerrado", "ok":"Aceptar"}});
      return true;
    }
    return false;
  }

  function restriccionCta() {
    if (isNullPer(txtCta.value)) {
      txtCtaNom.value = "";
      return true;
    }
    return false;
  }

  function restriccionCtaTr() {
    if (isNullPer(txtCtat.value)) {
      txtCtatNom.value = "";
      return true;
    }
    return false;
  }

  function restriccionCtaCod() {
    if (isNullPer($("#"+inputCtaMov).val())) {
      $("#"+inputCtaMov+"Nom").val("");
      return true;
    }
    return false;
  }

  function restriccionCtaCodTr() {
    if (isNullPer($("#"+inputCtaMov+"t").val())) {
      $("#"+inputCtaMov+"Nomt").val("");
      return true;
    }
    return false;
  }

  function restriccionModal() {
    if (restriccionCta()) {
      txtCta.focus();
      alWarningTimer({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar la CUENTA","timer":timeOutWarningSm}});
      return true;
    }
    $('#modalPol').modal('toggle');
    return false;
  }

  function restriccionModalTr() {
    if (restriccionCtaTr()) {
      txtCtat.focus();
      alWarningTimer({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar la CUENTA","timer":timeOutWarningSm}});
      return true;
    }
    $('#modalPolTr').modal('toggle');
    return false;
  }

  function restriccionModalDocp(saldo) {
    if (numDabono.value > Number(saldo)) {
      numDabono.focus(); 
      alWarning({"msg":{"title":"Error En el Abono","text":"Intenta registrar un Abono superior al saldo"}});      
      return true;
    } 
    if (numDabono.value < 0.00) {
      numDabono.focus(); 
      alWarning({"msg":{"title":"Error En el Abono","text":"No debe ingresar valor negativo"}});
      return true;
    } 
    $('#modalDocp').modal('toggle');
    return false;
  }


  function addRowPol(cta, ctaNom, debe, haber){
    const row = "<tr>"
                +"<td scope='col' class='ignore'>"
                  +"<div class='btn-group btn-group-sm' role='group' aria-label='Third group'>"
                    +"<button type='button' class='btn btn-danger btn-sm btn-actions' id='btnDel'><i class='fas fa-trash-alt'></i></button>"
                    +"<button type='button' class='btn btn-primary btn-sm btn-actions' id='btnEdit' data-toggle='modal' data-target='#modalPol'><i class='fas fa-edit'></i></button>"
                  +"</div>"
                +"</td>"
                +"<td id='dataCta'>"+cta+"</td>"
                +"<td id='dataCtaNom'>"+ctaNom+"</td>"
                +"<td id='dataDebe' class='text-right' contenteditable='true'>"+debe+"</td>"
                +"<td id='dataHaber' class='text-right' contenteditable='true'>"+haber+"</td>"
                +"</tr>";
    $("#tblPol tbody").append(row);
  }

  function addRowPolTr(cta, ctaNom, debe, haber){
    const row = "<tr>"
                +"<td scope='col' class='ignore'>"
                  +"<div class='btn-group btn-group-sm' role='group' aria-label='Third group'>"
                    +"<button type='button' class='btn btn-danger btn-sm btn-actions' id='btnDelt'><i class='fas fa-trash-alt'></i></button>"
                    +"<button type='button' class='btn btn-primary btn-sm btn-actions' id='btnEditt' data-toggle='modal' data-target='#modalPolTr'><i class='fas fa-edit'></i></button>"
                  +"</div>"
                +"</td>"
                +"<td id='dataCtat'>"+cta+"</td>"
                +"<td id='dataCtatNom'>"+ctaNom+"</td>"
                +"<td id='dataDebet' class='text-right' contenteditable='true'>"+debe+"</td>"
                +"<td id='dataHabert' class='text-right' contenteditable='true'>"+haber+"</td>"
                +"</tr>";
    $("#tblPolt tbody").append(row);
  }

  function consultarCheques(){
    if (restriccion(true)) {return};
    
    //txtNext = dtFec;

    const parametros = new FormData();
    parametros.append("action", "consultar");

    parametros.append("selTipo", selTipo.value);
    parametros.append("numNum", numNum.value);

    //txtNext.focus()

    $.ajax({
      data:  parametros,
      url:   window.location.origin+window.location.pathname+"actions.php",
      type:  "post",
      contentType: false,
      processData: false,
      async: false,
      success: function (jsonPhp) {
        //console.log(jsonPhp);
        const jsonJS = JSON.parse(jsonPhp);
        tblPolAnt = JSON.stringify(jsonJS.poli_det);

        if(jsonJS.error == true){
          alError(jsonJS);
        } else {
          limpiar();
          tblClear("tblPol");
          sumPol();

         
          if (isNullPer(jsonJS.polizas)) {
            nuevo = true;
            totant = 0;
          } else {
            dtFec.value = jsonJS.polizas.pol_fec;
            txtCon.value = jsonJS.polizas.pol_con;
            jsonJS.poli_det.forEach(function(i){
              addRowPol(i.pold_cta, i.pold_ctan, i.pold_debe, i.pold_haber);
            });
            sumPol();
            nuevo = false;
          }
          //(pressEnter) ? alClose() : alCloseFocus(txtNext);
          //pressEnter = false; 
          //alClose();
          //dtFec.focus();
        }
      }
    });
  }


  function guardarPoliza(imprimir = false){
    if (restriccion()) {return};

    colDocp = ["acciones", "tipo", "serie", "numero", "fecha", "fecha1", "concep", "saldo", "tipoanti", "noanti",  "abono"];
    colPol = ["acciones", "cta", "ctaNom", "debe", "haber"];
    tipop = selTipo.value;
    numDoc = numNum.value;

    const parametros = new FormData();
    parametros.append("action", "guardar");

    parametros.append("nuevo", nuevo);
    parametros.append("numNum", numNum.value);
    parametros.append("selTipo", selTipo.value);
    parametros.append("dtFec", dtFec.value);
    parametros.append("txtCon", txtCon.value);
    parametros.append("txtCodp", txtCodp.value);
    parametros.append("nitcli", nitcli);
    parametros.append("tblPol", tblToJson(colPol, "tblPol", 0));
    parametros.append("tblPolAnt", tblPolAnt);
    parametros.append("tblDocp", tblToJson(colDocp, "tblDocp", 0));

    //numNum.focus();
    
    $.ajax({
      data:  parametros,
      url:   window.location.origin+window.location.pathname+"actions.php",
      type:  "post",
      contentType: false,
      processData: false,
      beforeSend: function () {
     //   alLoad("Cargando...")
      },
      success: function (jsonPhp) {
        console.log(jsonPhp);
        const jsonJS = JSON.parse(jsonPhp);

        if(jsonJS.error==true){
          alError(jsonJS);
        } else {
          var snhacer = true;

          if (jsonJS.probpol1 != "X") {
            alError({"msg":{"type":"error","title":"PROBLEMA EN CUENTAS","text":"Alguna de las cuentas no esta asignada correctamente, verifique.", "ok":"Aceptar"}});
              var snhacer = false;
                     return true;
          }

          if (snhacer) {
            tblClear("tblDocp");
            tipoanti = "030";
            jsonJS.doctoscc.forEach(function(i){
              addRowDocp(i.dc_tipo, i.dc_serie, i.dc_num, i.dc_fec, i.dc_fec, i.dc_con, i.dc_sal, tipoanti, i.dc_noanti, i.dc_abop);
            });  
            //tblAllChecked("tblCaja", "cb", "cbTodos");
            sumCaja();
            $('#modalCheque').modal('toggle');
           // numNum.value = "";
            //alSuccess(JSON.parse('{"msg":'+decode_utf8(JSON.stringify(jsonJS.msg))+"}"));
            if (imprimir) {
              imprimirPoliza(true, tipop, numDoc);
            }
            limpiar();
            tblClear("tblPol");
            sumPol();
          }  
        }
      } 
    });
  }

  function imprimirPoliza(guardar = true, tipop, numDoc){
    //if (restriccion(false, false)) {return};
    colPol = ["acciones", "cta", "ctaNom", "debe", "haber"];

    const getTipoCod = "?tipop="+tipop;
    const getNum = "&numNum="+numDoc;
    const getFec = "&dtFec="+dtFec.value;
    const getCon = "&txtCon="+txtCon.value;
    const getTblPol = "&tblPol="+tblToJson(colPol, "tblPol", 0);

    var url = window.location.origin+window.location.pathname+"printdoc.php"+getNum+getFec+getCon+getTblPol+getTipoCod;

    window.open(url, '_blank');
  }

  function limpiarModalPol(){
    txtCta.value = "";
    txtCtaNom.value = "";
    numDebe.value = "";
    numHaber.value = "";
  }

  function limpiarModalDocp(){
      txtDserie.value = "";
      numDnum.value = "";
      numDnoanti.value ="";
      numDabono.value = "";
  }

  function limpiar(todo = false){
    dtFec.value= dateToday();
    //numTcam.value = (1).toFixed(6);
    //numTot.value = (0).toFixed(2);
    //txtBene.value = "";
    //txtCon.value = "";
  }

  function sumPol(){
    $("#tblPol #dataTotDebe").text(tblSumCol("tblPol", "dataDebe").toFixed(2));
    $("#tblPol #dataTotHaber").text(tblSumCol("tblPol", "dataHaber").toFixed(2));
  }


  $(document).ready(function() {
    //tblAllChecked("tblDocp", "cb", "cbTodos");
    $(this).find('input:visible:first').focus();
    document.thisformCh.dtFec.value = '<?php echo $dtFec; ?>';

    // SHOW MODAL
    $('#modalDocp').on('shown.bs.modal', function() {
      if (!isMobile()) {
        $(this).find('select:visible:first').focus();
      }
    });

    // SHOW MODAL
    $('#modalCheque').on('shown.bs.modal', function() {
      if (!isMobile()) {
        $(this).find('input:visible:first').focus();
      } else {
        limpiar();
        tblClear("tblPol");
        sumPol();
      }
    });


    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });

    // FOCUS TIPO POLIZA
    $("#selTipo").focus(function() {
      limpiar();
      tblClear("tblPol");
      sumPol();
    });

    // FOCUS NUMERO DE CHEQUE
    $("#numNum").focus(function() {

      limpiar();
      tblClear("tblPol");
      sumPol();

      const parametros = new FormData();
      parametros.append("action", "consultarCorrPol");

      parametros.append("selTipo", selTipo.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);

          const jsonJS = JSON.parse(jsonPhp);
            if (jsonJS.corrpol === null) {
               numNum.value=1;
            } else {
              numNum.value = jsonJS.corrpol.cp_num;
            }
          }
      });
    });


    // VALID NUMERO
    $("#numNum")
    .blur(function (){
      setTimeout(function(){
        if (!$('#selTipo').is(':focus') && $("#tblPol tbody").children().length == 0) {
          consultarCheques();
        }
      },0);
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-2-tab").click(); }
    })
    .change(function (){
      consultarCheques();
    });

    // VALID FECHAS
    $("#dtFec")
    .blur(function (){
      if (restriccionCamposVacios()) {return};
        txtThis = dtFec;

        const parametros = new FormData();
        parametros.append("action", "mCerrado");
        parametros.append("dtFec", txtThis.value);

        $.ajax({
          data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        async: false,
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (jsonJS.ciemes === null) {
              mesCerrado = false;
            } else {
              if (jsonJS.ciemes.ciem_stat == "C") {
                mesCerrado = true;
                setTimeout(function(){
                  if (!$('#numNum').is(':focus') && !$('#selTipo').is(':focus')) {
                    if ($('input, textarea').is(':focus')) {
                      restriccionMesCerrado();
                    }
                  }
                },0);
              } else {
                mesCerrado = false;
              }
            }
          }
        }
      });
    });


    // FOCUS FECHA
    $("#dtFec").focus(function (){
      if (restriccionCamposVacios()) {return};
    });

    // FOCUS VALOR CHEQUE, BENEFICIARIO, CONCEPTO
    $("#txtCon").focus(function (){
      if (restriccionCamposVacios()) {return};
    });

    // VALID CUENTA
    $("#txtCta")
    .focus(function() {
      inputCtaMov = $(this).attr('id');
    })
    .keypress(function(e) {
      const keycode = e.keyCode || e.which;
      if (keycode == '13') {pressEnter = true;}
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-001-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      txtGetValue = document.getElementById("txtCtaNom");
      txtNext = document.getElementById("numDebe");

      $(txtThis).off("blur");
      if (restriccionCta()) {return};

      const parametros = new FormData();
      parametros.append("action", "consultarCta");
      parametros.append("txtCod", txtThis.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Consultando...")
        },
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (jsonJS.cuentas === null) {
              txtGetValue.value = "";
              alErrorFocusTimer({"msg":{"type":"error","title":"No existe","text":"La cuenta "+txtThis.value+" no ha sido registrada", "ok":"Aceptar", "timer":timeOutErrorSm}}, txtThis);
            } else {
              if (jsonJS.cuentas.cta_con != "N") {
                txtGetValue.value = "";
                alErrorFocusTimer({"msg":{"type":"error","title":"No puede usar esta cuenta","text":"La cuenta "+txtThis.value+" no es de movimiento, no la puede usar", "ok":"Aceptar", "timer":timeOutErrorSm}}, txtThis);
              } else {
                txtGetValue.value = jsonJS.cuentas.cta_nom;
                (pressEnter) ? alClose() : alCloseFocus(txtNext);
              }
            }
            pressEnter = false;
            blurOn(txtThis, txtGetValue);
          }
        }
      });
    });


    // CLICK GUARDAR
    $("#btnGuardar").click(function (){
      guardarPoliza();
    });


    // CLICK GRABAR E IMPRIMIR
    $("#btnGuardarImprimir").click(function (){
      guardarPoliza(true);
    });

    
    // CLICK AGREGAR
    $("#btnAgregar").click(function () {
      if (restriccionModal()) {return};
      addRowPol(txtCta.value, txtCtaNom.value, isNullNumber(numDebe.value).toFixed(2), isNullNumber(numHaber.value).toFixed(2));
      limpiarModalPol();
      sumPol();
      $("#btnAdd").focus();
    });

  });

  // CHANGE CAJA
  $("body").on("change", "input[name=cb]", function (){
    /*if ($(this).find('td input[name="cb"]').is(":checked")) {
      sal = parseFloat($(this).find('#datasaldo').text());
      dataabono.text(isNullNumber(sal).toFixed(2));

    } else {
    dataabono.text() = 0;    
    } */   
    sumCaja();
  });

  // CLICK ADD
  $("body").on("click", "#btnAdd", function () {
    if (restriccionCamposVacios()) {return};
    if (restriccionMesCerrado()) {return};
    inputCtaMov = "txtCta";
    $('#modalPol').modal('toggle');
    $("#pills-000-tab").text("Agregar");
    $("#btnAgregar").show();
    $("#btnModificar").hide();
    limpiarModalPol();
  });

  // CLICK DEL
  $("body").on("click", "#btnDel", function() {
    const row = $(this).parents("tr");
    alDelete(function fn(){
      row.remove();
      sumPol();
    });
  });

  // CLICK EDIT
  $("body").on("click", "#btnEdit", function() {
    $('#pills-000-tab').text("Modificar");
    $('#btnAgregar').hide();
    $('#btnModificar').show();

    const dataCta = $(this).parents("tr").find("#dataCta");
    const dataCtaNom = $(this).parents("tr").find("#dataCtaNom");
    const dataDebe = $(this).parents("tr").find("#dataDebe");
    const dataHaber = $(this).parents("tr").find("#dataHaber");

    txtCta.value = dataCta.text();
    txtCtaNom.value = dataCtaNom.text();
    numDebe.value = dataDebe.text();
    numHaber.value = dataHaber.text();

    $("body").on("click", "#btnModificar", function() {
      if (restriccionModal()) {return};
      dataCta.text(txtCta.value);
      dataCtaNom.text(txtCtaNom.value);
      dataDebe.text(isNullNumber(numDebe.value).toFixed(2));
      dataHaber.text(isNullNumber(numHaber.value).toFixed(2));
      limpiarModalPol();
      sumPol();
    });
  });

  // CLICK EDIT DOCP
  $("body").on("click", "#btnEditDocp", function() {
    $('#pills-006-tab').text("Asignar Anticipo");
    $('#btnModificarDocp').show();

    const dataseried = $(this).parents("tr").find("#dataseried");
    const datanumd = $(this).parents("tr").find("#datanumd");
    const datafecd1 = $(this).parents("tr").find("#datafecd1");
    const dataconcep = $(this).parents("tr").find("#dataconcep");
    const datatipoanti = $(this).parents("tr").find("#datatipoanti");
    const datanoanti = $(this).parents("tr").find("#datanoanti");
    const datasaldo = $(this).parents("tr").find("#datasaldo");
    const dataabono = $(this).parents("tr").find("#dataabono");

    txtDserie.value = dataseried.text();
    numDnum.value = datanumd.text();
    dtDfec.value = datafecd1.text();
    txtDconcep.value = dataconcep.text();
    selDtipoanti.value = datatipoanti.text();
    numDnoanti.value = datanoanti.text();
    numDsaldo.value = datasaldo.text();
    numDabono.value = dataabono.text();

    $("body").on("click", "#btnModificarDocp", function() {
      if (restriccionModalDocp(datasaldo.text())) {return};
      if (numDnoanti.value == 0 && numDabono.value>0) {
        numDnoanti.focus();
        alWarning({"msg":{"title":"NO ASIGNO NUMERO DE ANTICIPO","text":"Debe asignar algun numero de anticipo."}});
        return;
      }
      datatipoanti.text(selDtipoanti.value);
      datanoanti.text(numDnoanti.value);
      dataabono.text(isNullNumber(numDabono.value).toFixed(2));
      limpiarModalDocp();
      sumCaja();
    });
  });

  $('#cbTodos').click(function () {
    cbAllChecked("tblDocp", "cb", "cbTodos");
    sumCaja();
  });

  // MODALPOL HIDDEN
  $('#modalPol').on('hidden.bs.modal', function (e) {
    $("body").off("click", "#btnModificar");
  });

  // MODALDOCP HIDDEN 
  $('#modalDocp').on('hidden.bs.modal', function (e) {
    $("body").off("click", "#btnModificarDocp");
  });

  // CLICK btnPartida
    $("#btnPartida").click(function (){
      if (restriccionCamposVacios()) {return};
      if (restriccionMesCerrado()) {return};
      if ($("#tblPol tbody").children().length != 0) {
        alWarning({"msg":{"title":"Ya existe partida","text":"La partida de este documento ya existe"}});
        return;
      }

      var totpol = $("#tblDocp #dataTotAbo").text();
      const parametros = new FormData();
      parametros.append("action", "generarPartida");
      parametros.append("ctacli", ctacli);

      $('#btnAddEdit').focus();

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Generando...")
        },
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            // Cuenta Anticipos
            if (!isNullPer(jsonJS.ctaAnti)) {
              addRowPol(jsonJS.ctaAnti.cta, jsonJS.ctaAnti.cta_nom, Number(totpol).toFixed(2), "0.00");
            } else {
              addRowPol("XXXXXXX", "Cuenta no definida", Number(totpol).toFixed(2), "0.00");
            }
            // Cuenta BANCOS
            if (!isNullPer(jsonJS.ctaCli)) {
              addRowPol(jsonJS.ctaCli.cta, jsonJS.ctaCli.cta_nom, "0.00", Number(totpol).toFixed(2));
            } else {
              addRowPol("XXXXXXX", "Ingrese cuenta del Cliente", "0.00", Number(totpol).toFixed(2));
            }
            sumPol();
            alClose();
          }
        }
      });
    });

  // FOCUS PILL SHOW
  $('a[data-toggle="pill"]').on('show.bs.tab', function (e) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;

      if (target == "#pills-11" && (isNullPer(txtSerieI.value) || isNullPer(numNumI.value))) {
        if(restriccionCamposVaciosiva(false)) {return false}
      } else if (target == "#pills-12" && (isNullPer(txtSerieI.value) || isNullPer(numNumI.value) || isNullPer(txtNitI.value))) {
        if(restriccionCamposVaciosiva()) {return false}
      }
  });

  // FOCUS PILL SHOWN
  $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
    //if (!isMobile()) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;
    //}
  });
</script>

<?php include('../banPrint/ban1010.php'); ?>
<?php include('../banPrint/ban1011.php'); ?>