<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);


$jsonDocp=json_decode($_GET["tblDocp"]);


class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
        $this->SetFont("Arial","I",6);
        $this->Ln();
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(1.5, 1, 1.5);
$pdf->SetFont("Arial","B",17);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.4;

$pdf->SetFont("","",8);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Documentos para emision de Cheque/Transferencia Proveedores"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight);

$header = array("Serie","Numero","Fecha","Concep","Saldo","Abono");
$pdf->SetFont("","B");
$pdf->SetWidths(array(2.8,2.8,1.8,7,2,2));
$pdf->SetAligns(array("L","L","C","C","C","C"));
$pdf->Row($header, $lineHeight);
$pdf->SetFont("");
$pdf->SetAligns(array("L","L","C","L","R","R"));
$saltot=0;
$abotot=0;
foreach ($jsonDocp as $obj) {
    $body = array(
        $obj->serie,
        $obj->numero,
        $obj->fecha,    
        utf8_decode($obj->concep),
        $obj->saldo,
        $obj->abono,
    );
    $pdf->RowBorderHidden($body, $lineHeight); 
    $saltot += $obj->saldo;
    $abotot += $obj->abono;
} 


$pdf->line($pdf->GetX(), $pdf->GetY(), 19.9, $pdf->GetY());

$pdf->SetAligns(array("","","","","R","R"));
$body = array(
    "",
    "",
    "",
    "Totales:",
    number_format($saltot,2),
    number_format($abotot,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.9, $pdf->GetY());

$pdf->Output(utf8_decode("Listado Pago Proveedores").".pdf","I");
?>