<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selClasi=$_GET["selClasi"];
$dtFec=$_GET["dtFec"];
$crTmone=$_GET["crTmone"];
if ($crTmone == 'L') {
    $tipomon=$empMoneda;
} else {
    $tipomon='DOLARES';
}   

//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec, $tipomon;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE DOCUMENTOS VENCIDOS CxC AL ".strftime("%d/%m/%Y", strtotime($dtFec))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("CIFRAS EXPRESADAS EN ").$tipomon,0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $header = array("SERIE","NUMERO","FEC/DOC","FEC/VENCE","TOTAL","ABONOS","SALDO");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,3,1.8,2,2.3,2.3,2.3));
        $this->SetAligns(array("C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selClasi=='000') {
    $sDoctoscc = "SELECT *, TRIM(dc_clien) AS dc_clien, TRIM(dc_codp) AS dc_codp, TRIM(dc_nit) AS dc_nit, (dc_tot-(dc_abo+dc_ret+dc_reti)) AS dc_saldod, TRIM(cl.cli_clas) AS dc_clas, TRIM(cla.cla_nom) AS cla_nom FROM doctoscc dc 
        LEFT JOIN cliencc cl ON dc.dc_emp=cl.cli_emp and dc.dc_codp=cl.cli_cod 
        LEFT JOIN clasic cla ON cl.cli_clas=cla.cla_cod
        WHERE dc_emp='$empCod' and dc_fecp<='$dtFec' and (dc_tot-(dc_abo+dc_ret+dc_reti))>0 ORDER BY cli_clas,cli_nom,dc_fec";
} else {
    $sDoctoscc = "SELECT *, TRIM(dc_clien) AS dc_clien, TRIM(dc_codp) AS dc_codp, TRIM(dc_nit) AS dc_nit, (dc_tot-(dc_abo+dc_ret+dc_reti)) AS dc_saldod, TRIM(cl.cli_clas) AS dc_clas, TRIM(cla.cla_nom) AS cla_nom FROM doctoscc dc 
        LEFT JOIN cliencc cl ON dc.dc_emp=cl.cli_emp and dc.dc_codp=cl.cli_cod 
        LEFT JOIN clasic cla ON cl.cli_clas=cla.cla_cod
        WHERE dc_emp='$empCod' and dc_fecp<='$dtFec' and (dc_tot-(dc_abo+dc_ret+dc_reti))>0 and cli_clas='$selClasi' ORDER BY cli_clas,cli_nom,dc_fec";
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.45;
$select["doctoscc"] = $db->query($sDoctoscc);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();

$ti_clasi="XXXZZZ999";
$subtot=0;
$subabo=0;
$subsal=0;
$subtotg=0;
$subabog=0;
$subsalg=0;
$tottot=0;
$totabo=0;
$totsal=0;
$t_lini=1;
$codp="";
$ti_codp="XXZZZ999";
$nomp="";
$clas="";
$clasnom="";

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["doctoscc"])) {
    if ($t_lini == 1) {
        $codp=$rec["dc_codp"];
        $nomp=utf8_decode($rec["cli_nom"]);
        $clas=$rec["cli_clas"];
        $clasnom=$rec["cla_nom"];
        //$t_lini=2;
    }
    if ($ti_codp!=$rec["dc_codp"]) {
        if ($t_lini > 1) {
            $pdf->ln();
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
            $pdf->Cell(.04,.4,"          SUBTOTAL ESTE CLIENTE",0,0,"L");
            $body = array(
                "",
                "",
                "",
                "",
                number_format($subtot, 2, '.', ','),
                number_format($subabo, 2, '.', ','),
                number_format($subsal, 2, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
        }             
        $subtot=0;
        $subabo=0;
        $subsal=0;
        $codp=$rec["dc_codp"];
        $ti_codp=$rec["dc_codp"];
        $nomp=utf8_decode($rec["cli_nom"]);
        if ($ti_clasi!=$rec["cli_clas"]) {
            if ($t_lini > 1) {
              $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
              $pdf->Cell(.04,.4,"          SUBTOTAL ESTE GRUPO",0,0,"L");
              $body = array(
                    "",
                    "",
                    "",
                    "",
                    number_format($subtotg, 2, '.', ','),
                    number_format($subabog, 2, '.', ','),
                    number_format($subsalg, 2, '.', ','),
                ); 
                $pdf->RowBorderHidden($body, $lineHeight);
                $subtotg=0;
                $subabog=0;
                $subsalg=0;
                $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.5, $pdf->GetY());
           }
           $clas=$rec["cli_clas"];
           $clasnom=$rec["cla_nom"];
           $pdf->SetFont("Arial","BU",9);
           $pdf->Cell($lineWidth,.7,$clasnom,0,1,"L");
           $ti_clasi=$rec["cli_clas"];
           //$pdf->ln(.4);
        }
        $pdf->SetFont("Arial","B",8);
        $pdf->Cell($lineWidth,.7,$codp."-".$nomp,0,1,"L");
        $pdf->SetFont("","",7);
        $t_lini=2;
    } 


    $codp=$rec["dc_codp"];
    $clas=$rec["cli_clas"];
    $seried=$rec["dc_serie"];
    $numd=$rec["dc_num"];
    $fec=$rec["dc_fec"];
    $fecp=$rec["dc_fecp"];
    $tcam=$rec["dc_tcam"];
    $tot=$rec["dc_tot"];
    $abo=$rec["dc_abo"]+$rec["dc_ret"]+$rec["dc_reti"];
    $saldod=$rec["dc_saldod"];
    if ($saldod>0) {
        if ($crTmone == 'L' && $tcam>1) {
            $saldod=round($saldod*$tcam,2);
        }
        if ($crTmone == 'E' && $tcam == 1) {
            $saldod=round($saldod/$empTcam,2);
        }
    }
    // Para saber cuantos dias
    $diff=$func->dateDiff($dtFec, $fecp);
    $dias=($diff->invert == 1) ? '-'.$diff->days : $diff->days;

    $subtot += $tot;
    $subabo += $abo;
    $subsal += $saldod;

    $subtotg += $tot;
    $subabog += $abo;
    $subsalg += $saldod;

    $tottot += $tot;
    $totabo += $abo;
    $totsal += $saldod;

    $body = array(
        $rec["dc_serie"],
        trim($rec["dc_num"]),
        strftime("%d/%m/%Y", strtotime($fec)),
        strftime("%d/%m/%Y", strtotime($fecp)),
        (round($tot, 2) != 0) ? number_format($tot, 2, '.', ',') : "",        
        (round($abo, 2) != 0) ? number_format($abo, 2, '.', ',') : "",        
        (round($saldod, 2) != 0) ? number_format($saldod, 2, '.', ',') : "",        
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->ln();
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
$pdf->Cell(.04,.4,"          SUBTOTAL ESTE CLIENTE",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    number_format($subtot, 2, '.', ','),
    number_format($subabo, 2, '.', ','),
    number_format($subsal, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
$pdf->Cell(.04,.4,"          SUBTOTAL ESTE GRUPO",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    number_format($subtotg, 2, '.', ','),
    number_format($subabog, 2, '.', ','),
    number_format($subsalg, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    number_format($tottot, 2, '.', ','),
    number_format($totabo, 2, '.', ','),
    number_format($totsal, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18, $pdf->GetY());
$pdf->ln(2);

$pdf->Cell(.04,.4,"                          ____________________                                                                                               ______________________",0,1,"L");
$pdf->Cell(.04,.4,"                               HECHO POR                                                                                                                   AUTORIZADO POR",0,0,"L");

$pdf->Output(utf8_decode("Doctos Vencidos CXC" ).".pdf","I");

$db->close();

?>