<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
include_once('../../../php/timezone.php');

# QUERYS
$sTpuesto = "SELECT * FROM tpuesto ORDER BY tpu_nom";
$sGrupo = "SELECT * FROM grupo WHERE gru_emp='".$_SESSION['empCod']."'";
$sDep = "SELECT * FROM dep WHERE dep_emp='".$_SESSION['empCod']."'";
$sBodegapro = "SELECT * FROM bodegapro";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tpuesto"] = $db->query($sTpuesto);
$select["grupo"] = $db->query($sGrupo);
$select["dep"] = $db->query($sDep);
$select["bodegapro"] = $db->query($sBodegapro);

$dtFec=date("Y-m-d");
$nAnio=date("Y");
$nMes=date("m");

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];
$empNit = $_SESSION['empNit'];

?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
      ?>

      <!-- MODAL DETALLE DE PLANILLA -->
      <div class="modal fade" id="modalNomper" tabindex="-1" role="dialog" aria-labelledby="modalNomperTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-00-tab" data-toggle="pill" href="#pills-00" role="tab" aria-controls="pills-00" aria-selected="true"></a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-light" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-00" role="tabpanel" aria-labelledby="pills-00-tab">
                  
                  <form action="" name="" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group">

                      <div class="form-row">
                        <div class="col-md-2">
                          <label class="font-size-sm text-success" for="numCoddm">Código Empleado</label>
                          <input type="number" class="form-control form-control-sm form-control-as" id="numCoddm" maxlength="20" disabled>
                        </div>
                        <div class="col-sm-9 col-md-5">
                          <label class="font-size-sm text-success" for="txtNomdm">Nombre:</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtNomdm" maxlength="120" disabled>
                        </div>
                        <div class="col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numSnomdm">Sueldo Nominal Diario</label>
                          <input type="text" class="form-control form-control-sm form-control-as dec-4" id="numSnomdm" oninput="numberDec(this, 14, 4);" disabled>
                        </div>
                        <div class="col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numSnommendm">Sueldo Nominal Quincenal</label>
                          <input type="text" class="form-control form-control-sm form-control-as dec-2" id="numSnommendm" disabled>
                        </div>
                      </div>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDtradm">Días Trabajados</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDtradm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDseptdm">Septimos</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDseptdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDferidm">Asuetos/Feriados/Boni. Incent.</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDferidm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDsusidm">Días Suspendido</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDsusidm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDvacadm">Días Vacaciones</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDvacadm">
                        </div>
                      </div>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numHsimdm">H/Extras Simples</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numHsimdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numHdobdm">H/Extras Dobles</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numHdobdm">
                        </div>
                      </div>
                      <h5 class="text-success">INGRESOS:</h5>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numSorddm">Sueldo Ordinario</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numSorddm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numSseptdm">Sueldo Septimos</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numSseptdm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numSferidm">Sueldo Feriados/Asuato/Boni. Incent.</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numSferidm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numSextsdm">Sueldo Extra Simple</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numSextsdm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numSextddm">Sueldo Extra Doble</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numSextddm" disabled>
                        </div>
                      </div>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numBonidm">Bonificacion Ley</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numBonidm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numBoniidm">Boni. por Desempeño</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numBoniidm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numBonoedm">Bono Extra</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numBonoedm">
                        </div>
                      </div>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numDepredm">Deprec. Vehiculo</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDepredm">
                        </div>
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numViatidm">Viaticos</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numViatidm">
                        </div>
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numComidm">Comisiones</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numComidm">
                        </div>
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numOtrpdm">Otros Ingresos</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numOtrpdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numTotdevdm">Total Devengado</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numTotdevdm" disabled>
                        </div>
                      </div>
                      <h5 class="text-success">DESCUENTOS:</h5>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numIgssdm">IGSS</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numIgssdm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numIsrdm">ISR</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numIsrdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numAntidm">Anticipo</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numAntidm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numPrebdm">Prestamo Bancario</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numPrebdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numPreedm">Prestamo Empresa</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numPreedm">
                        </div>
                      </div>
                      <div class="form-row align-items-end">
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numUnifdm">Uniforme</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numUnifdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numLentdm">Lentes</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numLentdm">
                        </div>
                        <div class="col-6 col-sm-3 col-md-2">
                          <label class="font-size-sm text-success" for="numDesjdm">Descuentos Judiciales</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDesjdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numDescvm">Descuentos Varios</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numDescvdm">
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numTotdesdm">Total Descuentos</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numTotdesdm" disabled>
                        </div>
                        <div class="col-6 col-sm-2">
                          <label class="font-size-sm text-success" for="numLiqrecdm">Liquido a Recibir</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numLiqrecdm" style="font-size:25px; font-weight: bold;"disabled>
                        </div>
                      </div>

                    </div>

                    <button type="button" class="btn btn-success btn-block" id="btnAgregar">Agregar</button>

                    <button type="button" class="btn btn-warning btn-block" id="btnModificar">Modificar Registro</button>
                  </form>

                </div>
              </div>

            </div>
          </div>
        </div>
      </div>

      <!-- MODAL PARA AGREGAR OTRO EMPLEADO A LA PLANILLA -->
      <div class="modal fade" id="modalNomperag" tabindex="-1" role="dialog" aria-labelledby="modalNomperagTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-000-tab" data-toggle="pill" href="#pills-000" role="tab" aria-controls="pills-000" aria-selected="true">Agregar Empleado</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" id="pills-001-tab" data-toggle="pill" href="#pills-001" role="tab" aria-controls="pills-001" aria-selected="true">Buscar Empleados</a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-light" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-000" role="tabpanel" aria-labelledby="pills-000-tab">
                  <form action="" name="" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group">
                      <div class="form-row">
                        <div class="col-md-3">
                          <label class="font-size-sm text-success" for="numCoddag">Código Empleado</label>
                          <input type="number" class="form-control form-control-sm form-control-as" id="numCoddag">
                        </div>
                        <div class="col-sm-9 col-md-9">
                          <label class="font-size-sm text-success" for="txtNomdag">Nombre:</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtNomdag" maxlength="120" disabled>
                        </div>
                      </div>

                    </div>
                    <div class="form-row">
                      <div class="col-6 mt-2">
                        <button class="btn btn-success btn-block" id="btnAgregarag" type="button">Agregar</button>
                      </div>
                      <div class="col-6 mt-2">
                        <button class="btn btn-danger btn-block" id="btnCancelarag" type="button">Cancelar</button>
                      </div>
                    </div>
                  </form>
                </div>
                <div class="tab-pane fade" id="pills-001" role="tabpanel" aria-labelledby="pills-001-tab">
                  <?php
                    $a='000';
                    $b='001';
                    include('../busEmpleado2/index.html');
                  ?>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>

      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Mantenimiento</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-1-tab" data-toggle="pill" href="#pills-1" role="tab" aria-controls="pills-1" aria-selected="true">Buscar Planillas</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-2-tab" data-toggle="pill" href="#pills-2" role="tab" aria-controls="pills-2" aria-selected="true">Buscar Empleado</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">

                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-md-10">
                      <div class="form-group">
                        <div class="form-row">
                          <div class="col-2.5">
                                <label class="font-size-md" for="numNum">Número de Planilla</label>
                                <input type="number" class="form-control form-control-md form-control-as" id="numNum" placeholder="0">
                          </div>
                          <div class="col-2">
                                <label class="font-size-md" for="dtDel">Periodo del:</label>
                                <input type="date" class="form-control form-control-md form-control-as" id="dtDel" placeholder="" disabled>
                          </div>
                          <div class="col-2">
                                <label class="font-size-md" for="dtAl">Al</label>
                                <input type="date" class="form-control form-control-md form-control-as" id="dtAl" maxlength="20" disabled>
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-sm-3">
                            <label class="font-size-md" for="selBodegapro">Bodega</label>
                            <select class="form-control form-control-md form-control-as" name="selBodegapro" id="selBodegapro">
                              <?php
                                while ($rec = $db->fetchAssoc($select['bodegapro'])) {
                                  echo  "<option value={$rec['bp_cod']}>".utf8_encode($rec['bp_nom']).'</option>';
                                }
                              ?>
                            </select>
                          </div>
                          <div class="col-sm-2.5">
                            <label  class="font-size-md" for="selDep">Departamento dentro de la empresa</label>
                            <select class="form-control form-control-md form-control-as" name="selDep" id="selDep">
                              <option value="000">Todos los Departamentos</option>
                              <?php
                                while ($rec = $db->fetchAssoc($select['dep'])) {
                                  echo  "<option value={$rec['dep_cod']}>".utf8_encode($rec['dep_nom']).'</option>';
                                }
                              ?>
                            </select>
                          </div>
                          <div class="col-sm-2">
                            <label class="font-size-md" for="selPuesto">Puesto/Area</label>
                            <select class="form-control form-control-md form-control-as" name="selPuesto" id="selPuesto">
                              <option value="000">Todos los Puestos/Areas</option>
                              <?php
                                while ($rec = $db->fetchAssoc($select['tpuesto'])) {
                                  echo  "<option value={$rec['tpu_cod']}>".utf8_encode($rec['tpu_nom']).'</option>';
                                }
                              ?>
                            </select >
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-md-2">
                            <label class="font-size-md" for="numCod">Código Empleado</label>
                            <input type="number" class="form-control form-control-md form-control-as" id="numCod">
                          </div>
                          <div class="col-md-6">
                            <label class="font-size-md" for="txtNomn">Nombre:</label>
                            <input type="text" class="form-control form-control-md form-control-as" id="txtNomn" maxlength="120" disabled>
                          </div>
                          <div class="col-2">
                            <label  class="font-size-md"> </label>
                            <button class="btn btn-warning btn-block btn-lg" id="btnMostrar" type="button">Mostrar</button>
                          </div>
                        </div>

                        <div class="form-row">
                        </div>
                      </div>

                      <h3 class="text-light"></h3>
                      <div class="form-group">
                        <div class="form-row">
                          <div class="col-12 text-right mb-2">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-md-12">
                            <div class="table-responsive">
                              <table class="table table-hover table-bordered table-dark table-striped table-md" id="tblNomper">
                            <!---    <style>
                                  tr:nth-child(even) {
                                    background-color: #283747;
                                  }  -->
                                </style> 
                                <thead>
                                  <tr>
                                    <th scope="col" class="text-center ignore" width="50">ACCIONES</th>
                                    <th scope="col" class="text-center" width="70">CODIGO</th>
                                    <th scope="col" class="text-center" width="250">NOMBRE EMPLEADO</th>
                                    <th scope="col" class="text-center" width="130">PUESTO</th>
                                    <th scope="col" class="text-center" width="80">TOTAL DEVENGADO</th>
                                    <th scope="col" class="text-center" width="80">TOTAL DESCUENTOS</th>
                                    <th scope="col" class="text-center" width="80">LIQUIDO</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                  <th scope="col" class="ignore"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col" class="text-right">Totales</th>
                                  <th scope="col" id="dataTotDevT" class="text-right">0.00</th>
                                  <th scope="col" id="dataTotDescT" class="text-right">0.00</th>
                                  <th scope="col" id="dataTotLiqT" class="text-right">0.00</th>
                                </tfoot>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>

                      <h3 class="text-light"></h3>
                      <div class="form-group">
                        <div class="form-row">
                        </div>
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group position-fixed-md">

                        <div class="form-row">
                          <div class="col-12 mt-2">
                            <button class="btn btn-outline-success btn-block" id="btnExcel" type="button">Generar Excel</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-outline-danger btn-block" id="btnBorrar" type="button">Borrar Planilla Completa</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-outline-warning btn-block" id="btnAgregao" type="button">Agregar Otro Empleado</button>
                          </div>
                          <div class="col-3 col-md-12"></div>
                        </div>

                      </div>
                    </div>
                  </div>
                </form>
              </div>
              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busPlani/index.html');
                ?>
              </div>
              <div class="tab-pane fade" id="pills-2" role="tabpanel" aria-labelledby="pills-2-tab">
                <?php
                  $a='0';
                  $b='2';
                  include('../busEmpleado/index.html');
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var nuevo = true;
  var nuevoArtic = true;
  var mesCerrado = false;
  var inputCtaMov = "txtCta";
  var totant = 0;
  var inputPlani = "numNum";
  var tblNomperAnt;
  var tblPolAnt;
  var btnAddEdit = "00";
  var inputArtic = "txtCodd";
  var unimed = "XXX";
  var ctaInc = false;
  var inputEmple = "numCoddag";

  
  const numNum = document.thisform.numNum;
  const dtDel = document.thisform.dtDel;
  const dtAl = document.thisform.dtAl;


  function restriccion(consultar = false){
    if (!consultar) {
      if (isNullPer(numNum.value)  || numNum.value == 0) {
        numNum.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE PLANILLA"}});
        return true;
      }
    } else {
      if (isNullPer(numNum.value)) {
        numNum.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE PLANILLA"}});
        return true;
      }
    }
    return false;
  }

  function restriccionCamposVacios() {
    if (isNullPer(numNum.value)) {
      numNum.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE PLANILLA"}});
      return true;
    }
    return false;
  }

    
  function addRowNomper(cod, nom, pue, totdev, totdes, liqrec){
    const row = "<tr>"
                +"<td scope='col' class='ignore'>"
                  +"<div class='btn-group btn-group-sm' role='group' aria-label='Third group'>"
                    +"<button type='button' class='btn btn-danger btn-sm btn-actions' id='btnDel'><i class='fas fa-trash-alt'></i></button>"
                    +"<button type='button' class='btn btn-primary btn-sm btn-actions' id='btnEdit' data-toggle='modal' data-target='#modalNomper'><i class='fas fa-edit'></i></button>"
                  +"</div>"
                +"</td>"
                +"<td id='dataCod'>"+cod+"</td>"
                +"<td id='dataNom'>"+nom+"</td>"
                +"<td id='dataPuesto'>"+pue+"</td>"
                +"<td id='dataTotdev' class='text-right'>"+totdev+"</td>"
                +"<td id='dataTotdes' class='text-right'>"+totdes+"</td>"
                +"<td id='dataLiqrec' class='text-right'>"+liqrec+"</td>"
                +"</tr>";
    $("#tblNomper tbody").append(row);
  }

  function consultarPla(){
    if (restriccion(true)) {return};
    
    if (!isNullPer(numNum.value)) {
      const parametros = new FormData();
      parametros.append("action", "consultarPla");

      parametros.append("numNum", numNum.value);
      parametros.append("selBodegapro", selBodegapro.value);
      parametros.append("selDep", selDep.value);
      parametros.append("selPuesto", selPuesto.value);
      parametros.append("numCod", numCod.value);

      //txtNext.focus()

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);
          tblNomperAnt = JSON.stringify(jsonJS.nomper);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (isNullPer(jsonJS.nomper)) {
              selPuesto.focus();
              alWarning({"msg":{"title":"PLANILLA NO REGISTRADA","text":"No hay planilla registrada con estos parametros, revise."}});
              return true;
            } else {
            //dtDel.value = jsonJS.nomper.np_fini;
            //dtAl.value = jsonJS.nomper.np_ffin;
            jsonJS.nomper.forEach(function(i){
              // dtDel.value= i.np_fini;
              // dtAl.value= i.np_ffin;
               addRowNomper(i.np_cod, i.mae_nom+" "+i.mae_ape, i.tpu_nom, i.np_totdev, i.np_totdes, i.np_liqrec);
            });  
            sumDetao();
            nuevo = false;
          }
        }
      }
    });
    }      
  }

  function consultarPla1(){
    if (restriccion(true)) {return};
    
    if (!isNullPer(numNum.value)) {
      const parametros = new FormData();
      parametros.append("action", "consultarPla1");

      parametros.append("numNum", numNum.value);

      //txtNext.focus()

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);
          tblNomperAnt = JSON.stringify(jsonJS.nomper);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (isNullPer(jsonJS.nomper)) {
              numNum.focus();
              alWarning({"msg":{"title":"PLANILLA NO REGISTRADA","text":"Esta Planilla no ha sido registrada, revise."}});
              return true;
            } else {
            //dtDel.value = jsonJS.nomper.np_fini;
            //dtAl.value = jsonJS.nomper.np_ffin;
            jsonJS.nomper.forEach(function(i){
               dtDel.value= i.np_fini;
               dtAl.value= i.np_ffin;
               //addRowNomper(i.np_cod, i.mae_nom+" "+i.mae_ape, i.tpu_nom, i.np_totdev, i.np_totdes, i.np_liqrec);
            });  
            //sumDetao();
            nuevo = false;
          }
        }
      }
    });
    }      
  }

  function consultarNp(){
   
    if (!isNullPer(numCoddm.value)) {

      const parametros = new FormData();
      parametros.append("action", "consultarNp");

      parametros.append("numNum", numNum.value);
      parametros.append("numCod", numCoddm.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (isNullPer(jsonJS.nomper)) {
            } else {
              numSnomdm.value = Number(jsonJS.nomper.np_snom/15).toFixed(4);
              numSnommendm.value = Number(jsonJS.nomper.np_snom).toFixed(2);
              sueldia = Number(jsonJS.nomper.np_snom/15).toFixed(4);
              suelhora = round(sueldia/8,5);
              boni = Number(jsonJS.nomper.mae_bonil).toFixed(2);
              bonidia = round(boni/15,5);
              numDtradm.value = (Number(jsonJS.nomper.np_dtra)).toFixed(1);
              numDseptdm.value = (Number(jsonJS.nomper.np_dsept)).toFixed(1);
              numDferidm.value = (Number(jsonJS.nomper.np_dferi)).toFixed(1);
              numDsusidm.value = (Number(jsonJS.nomper.np_dsusi)).toFixed(1);
              numDvacadm.value = (Number(jsonJS.nomper.np_dvaca)).toFixed(1);
              numHsimdm.value = (Number(jsonJS.nomper.np_hsim)).toFixed(2);
              numHdobdm.value = (Number(jsonJS.nomper.np_hdob)).toFixed(2);
              numSorddm.value = (Number(jsonJS.nomper.np_sord)).toFixed(2); 
              numSseptdm.value = (Number(jsonJS.nomper.np_ssept)).toFixed(2); 
              numSferidm.value = (Number(jsonJS.nomper.np_sferi)).toFixed(2); 
              numBonidm.value = (Number(jsonJS.nomper.np_boni)).toFixed(2); 
              numSextsdm.value = (Number(jsonJS.nomper.np_sexts)).toFixed(2); 
              numSextddm.value = (Number(jsonJS.nomper.np_sextd)).toFixed(2); 
              numBoniidm.value = (Number(jsonJS.nomper.np_bonii)).toFixed(2); 
              numBonoedm.value = (Number(jsonJS.nomper.np_bonoe)).toFixed(2); 
              numDepredm.value = (Number(jsonJS.nomper.np_depre)).toFixed(2); 
              numViatidm.value = (Number(jsonJS.nomper.np_viati)).toFixed(2); 
              numComidm.value = (Number(jsonJS.nomper.np_comi)).toFixed(2); 
              numOtrpdm.value = (Number(jsonJS.nomper.np_otrp)).toFixed(2); 
              numTotdevdm.value = (Number(jsonJS.nomper.np_totdev)).toFixed(2); 
              numIgssdm.value = (Number(jsonJS.nomper.np_igss)).toFixed(2); 
              numIsrdm.value = (Number(jsonJS.nomper.np_isr)).toFixed(2); 
              numAntidm.value = (Number(jsonJS.nomper.np_anti)).toFixed(2); 
              numUnifdm.value = (Number(jsonJS.nomper.np_unif)).toFixed(2); 
              numLentdm.value = (Number(jsonJS.nomper.np_lent)).toFixed(2); 
              numPrebdm.value = (Number(jsonJS.nomper.np_preb)).toFixed(2); 
              numPreedm.value = (Number(jsonJS.nomper.np_pree)).toFixed(2); 
              numDesjdm.value = (Number(jsonJS.nomper.np_desj)).toFixed(2); 
              numDescvdm.value = (Number(jsonJS.nomper.np_otrd)).toFixed(2); 
              numTotdesdm.value = (Number(jsonJS.nomper.np_totdes)).toFixed(2); 
              numLiqrecdm.value = (Number(jsonJS.nomper.np_liqrec)).toFixed(2); 
              igsssn=jsonJS.nomper.np_igsssn;
            }
          }
        }
      });
    }
  }  

  function guardarNp(){
   
    if (!isNullPer(numCoddm.value)) {

      const parametros = new FormData();
      parametros.append("action", "guardar");

      parametros.append("numNum", numNum.value);
      parametros.append("numCod", numCoddm.value);
      parametros.append("numDtra", numDtradm.value);
      parametros.append("numDsept", numDseptdm.value);
      parametros.append("numDferi", numDferidm.value);
      parametros.append("numDsusi", numDsusidm.value);
      parametros.append("numDvaca", numDvacadm.value);
      parametros.append("numHsim", numHsimdm.value);
      parametros.append("numHdob", numHdobdm.value);
      parametros.append("numSord", numSorddm.value);
      parametros.append("numSsept", numSseptdm.value);
      parametros.append("numSferi", numSferidm.value);
      parametros.append("numBoni", numBonidm.value);
      parametros.append("numSexts", numSextsdm.value);
      parametros.append("numSextd", numSextddm.value);
      parametros.append("numBonii", numBoniidm.value);
      parametros.append("numBonoe", numBonoedm.value);
      parametros.append("numDepre", numDepredm.value);
      parametros.append("numViati", numViatidm.value);
      parametros.append("numComi", numComidm.value);
      parametros.append("numOtrp", numOtrpdm.value);
      parametros.append("numTotdev", numTotdevdm.value);
      parametros.append("numIgss", numIgssdm.value);
      parametros.append("numIsr", numIsrdm.value);
      parametros.append("numAnti", numAntidm.value);
      parametros.append("numUnif", numUnifdm.value);
      parametros.append("numLent", numLentdm.value);
      parametros.append("numPreb", numPrebdm.value);
      parametros.append("numPree", numPreedm.value);
      parametros.append("numDesj", numDesjdm.value);
      parametros.append("numDescv", numDescvdm.value);
      parametros.append("numTotdes", numTotdesdm.value);
      parametros.append("numLiqrec", numLiqrecdm.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            //alSuccess(jsonJS);
          }
        }
      });
    }
  }  

  function borrarReg(){
   
    if (!isNullPer(numCoddm.value)) {

      const parametros = new FormData();
      parametros.append("action", "borrarReg");

      parametros.append("numNum", numNum.value);
      parametros.append("numCod", numCoddm.value);
      parametros.append("dtDel", dtDel.value);
      parametros.append("dtAl", dtAl.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            //alSuccess(jsonJS);
          }
        }
      });
    }
  }  

  function limpiarModalNomper(){
    numSnomdm.value = "";
    numSnommendm.value = "";
    numDtradm.value = "";
    numDseptdm.value = "";
    numDferidm.value = "";
    numDsusidm.value = "";
    numDvacadm.value = "";
    numHsimdm.value = "";
    numHdobdm.value = "";
    numSorddm.value = ""; 
    numSseptdm.value = ""; 
    numSferidm.value = ""; 
    numBonidm.value = ""; 
    numSextsdm.value = ""; 
    numSextddm.value = ""; 
    numBoniidm.value = ""; 
    numComidm.value = ""; 
    numBonoedm.value = ""; 
    numDepredm.value = ""; 
    numViatidm.value = ""; 
    numOtrpdm.value = ""; 
    numTotdevdm.value = ""; 
    numIgssdm.value = ""; 
    numIsrdm.value = ""; 
    numAntidm.value = ""; 
    numUnifdm.value = ""; 
    numLentdm.value = ""; 
    numPrebdm.value = ""; 
    numPreedm.value = ""; 
    numDesjdm.value = ""; 
    numDescvdm.value = ""; 
    numTotdesdm.value = ""; 
    numLiqrecdm.value = ""; 
  } 

  function calcular(){
    const pIgsse = <?php echo $_SESSION['pIgsse']; ?>;
    numSorddm.value = round(sueldia*numDtradm.value,2).toFixed(2); 
    numSseptdm.value = round(sueldia*numDseptdm.value,2).toFixed(2); 
    numSferidm.value = round(sueldia*numDferidm.value,2).toFixed(2); 
    //numBonidm.value = round(bonidia*numDtradm.value,2).toFixed(2); 
    numSextsdm.value = round((suelhora*1.5)*numHsimdm.value,2).toFixed(2); 
    numSextddm.value = round((suelhora*2)*numHdobdm.value,2).toFixed(2); 
    if (igsssn=='S') {
      numIgssdm.value=round((Number(numSorddm.value)+Number(numSseptdm.value)+Number(numSextsdm.value)+Number(numSextddm.value)+Number(numComidm.value)+Number(numOtrpdm.value))*pIgsse/100,2).toFixed(2);
    } else {
      numIgssdm.value=(0).toFixed(2);  
    }

    numTotdevdm.value=round((Number(numSorddm.value)+Number(numSseptdm.value)+Number(numSferidm.value)+Number(numBonidm.value)+Number(numSextsdm.value)+Number(numSextddm.value)+Number(numBoniidm.value)+Number(numBonoedm.value)+Number(numDepredm.value)+Number(numViatidm.value)+Number(numComidm.value)+Number(numOtrpdm.value)),2).toFixed(2);

    numTotdesdm.value=round((Number(numIgssdm.value)+Number(numIsrdm.value)+Number(numAntidm.value)+Number(numUnifdm.value)+Number(numLentdm.value)+Number(numPrebdm.value)+Number(numPreedm.value)+Number(numDesjdm.value)+Number(numDescvdm.value)),2).toFixed(2);

    numLiqrecdm.value=(Number(numTotdevdm.value)-Number(numTotdesdm.value)).toFixed(2);
  } 

  function limpiar(todo = false){
    dtAl.value= '<?php echo $dtFec; ?>';
    dtDel.value= '<?php echo $dtFec; ?>';
  }


  function sumDetao(){
    $("#tblNomper #dataTotDevT").text(tblSumCol("tblNomper", "dataTotdev").toFixed(2));
    $("#tblNomper #dataTotDescT").text(tblSumCol("tblNomper", "dataTotdes").toFixed(2));
    $("#tblNomper #dataTotLiqT").text(tblSumCol("tblNomper", "dataLiqrec").toFixed(2));
  }


  $(document).ready(function() {
    $(this).find('input:visible:first').focus();
    //document.thisform.dtFec.value = '<?php echo $dtFec; ?>';
    //document.thisform.dtFvalida.value = '<?php echo $dtFec; ?>';
    numNum.value="";
    dtDel.value = dateToday();
    dtAl.value = dateToday();

    // SHOW MODAL
    $('#modalNomper, #modalNomperag').on('shown.bs.modal', function() {
      if (!isMobile()) {
        $(this).find('input:enabled:first').focus();
      }
    });

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });

    // FOCUS NUMERO DE ORDEN
    $("#numNum")
    .focus(function() {
      numNum.value="";
      tblClear("tblNomper");
      sumDetao();
      limpiar();
    })
    .keypress(function(e) {
      const keycode = e.keyCode || e.which;
      if (keycode == '13') {pressEnter = true;}
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-1-tab").click(); }
    })
    .change(function (){
      consultarPla1();
    });

    // VALID CODIGO A AGREGAR
    $("#numCoddag")
    .focus(function() {
      inputEmple = $(this).attr('id');
      txtNomdag.value = "";
    })
    .keypress(function(e) {
      const keycode = e.keyCode || e.which;
      if (keycode == '13') {pressEnter = true;}
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-001-tab").click(); }
    })
    .change(function (){
      if (restriccion(true)) {return};

      const parametros = new FormData();
      parametros.append("action", "consultarEmple");
      parametros.append("numNum", numNum.value);
      parametros.append("numCoddag", numCoddag.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
      /*  beforeSend: function () {
          alLoad("Consultando...")
        }, */
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (!isNullPer(jsonJS.nomper)) {
//            if (jsonJS.nomper != null ) {
                numCoddag.value="";
                numCoddag.focus();
                alWarning({"msg":{"title":"YA REGISTRADO","text":"Este codigo ya esta agregado en la planilla, no lo puede agregar dos veces"}});
                return true;
            } else {
              if (isNullPer(jsonJS.maestro)) {
                numCoddag.value="";                
                numCoddag.focus();
                alWarning({"msg":{"title":"NO EXISTE","text":"Este codigo no ha sido registrado"}});
                return true;
              } else {
                txtNomdag.value = jsonJS.maestro.mae_nom+" "+jsonJS.maestro.mae_ape;
                //$("#selDepto").trigger("change");
              }
            }
          }
        }
      });
    });

    // VALID CODIGO
    $("#numCod")
    .focus(function() {
      numCod.value="";
      txtNomn.value = "";
      inputEmple = $(this).attr('id');
    })
    .keypress(function(e) {
      const keycode = e.keyCode || e.which;
      if (keycode == '13') {pressEnter = true;}
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-2-tab").click(); }
    })
    .change(function (){
      if (restriccion(true)) {return};

      const parametros = new FormData();
      parametros.append("action", "consultarEmple");
      parametros.append("numNum", numNum.value);
      parametros.append("numCoddag", numCod.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
      /*  beforeSend: function () {
          alLoad("Consultando...")
        }, */
        success: function (jsonPhp) {
          console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
          } else {
            if (isNullPer(jsonJS.maestro)) {
              numCod.value="";                
              numCod.focus();
              alWarning({"msg":{"title":"NO EXISTE","text":"Este codigo no ha sido registrado"}});
              return true;
            } else {
              txtNomn.value = jsonJS.maestro.mae_nom+" "+jsonJS.maestro.mae_ape;
              //$("#selDepto").trigger("change");
            }
          }
        }
      });
    });


    // FOCUS ORDEN DE COMPRA
  //  $("#numOrdenc").change(function (){
  //    consultarOrden();
  //  });


    // VALID Cantidad detalle modal
    $("#numDtradm, #numDseptdm, #numDferidm, #numDvacadm, #numHsimdm, #numHdobdm, #numSorddm, #numSextsdm, #numSextddm, #numBonidm")
    .blur(function (){
      calcular();
    });

    $("#numBoniidm, #numBonoedm, #numDepredm, #numViatidm, #numComidm, #numOtrpdm, #numIgssdm, #numIsrdm")
    .blur(function (){
      calcular();
    });

    $("#numAntidm, #numUnifdm, #numLentdm, #numPrebdm, #numPreedm, #numDesjdm, #numDescvdm")
    .blur(function (){
      calcular();
    });

    // CLICK EXCEL
    $("#btnExcel").click(function (){
      if (restriccion(true)) {return};

      const getnumNum = "?numNum="+numNum.value;
      const getdtDel = "&dtDel="+dtDel.value;      
      const getdtAl = "&dtAl="+dtAl.value;      
      const getselBodegapro = "&selBodegapro="+selBodegapro.value;
      const getselDep = "&selDep="+selDep.value;
      const getselPuesto = "&selPuesto="+selPuesto.value;
      const getnumCod = "&numCod="+numCod.value;

      var url = window.location.origin+window.location.pathname+"excel.php"+getnumNum+getdtDel+getdtAl+getselBodegapro+getselDep+getselPuesto+getnumCod;

      window.location.href = url;
    });

    // CLICK BORRAR
    $("#btnBorrar").click(function (){

      if (restriccion(true)) {return};

      const numDoc = numNum.value;
      const del = dtDel.value;
      const al = dtAl.value;

      //numNum.focus();

      const fnT = function(){

        const parametros = new FormData();
        parametros.append("action", "borrar");
        parametros.append("numNum", numDoc);
        parametros.append("dtDel", del);
        parametros.append("dtAl", al);

        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            //console.log(jsonPhp);
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              numNum.value = "";
              limpiar();
              tblClear("tblNomper");
              sumDetao();
              $("#btnBorrar").focus(function (){
                numNum.focus();
              });
              alSuccess(jsonJS);
            }
          }
        });
      }

      const fnF = function(){
        return true;
      }
      admClave(fnT, fnF);
    });

  }); 
    
  // CLICK Agregar otro
  $("#btnAgregao").click(function (){
    if (restriccion(true)) {return};
    numCoddag.value="";
    txtNomdag.value="";
    $('#modalNomperag').modal('toggle');
//    $('#modalNomperag').find('input:visible:first').focus();
  });

  $("#btnMostrar").click(function (){
    if (restriccion(true)) {return};
    tblClear("tblNomper");
    sumDetao();
    consultarPla();
  });

  // CLICK Cancelar el agregado
  $("#btnAgregarag").click(function (){

    if (isNullPer(numCoddag.value)) {
      numCoddag.value="";
      numCoddag.focus();      
      alWarning({"msg":{"title":"DEBE INGRESAR EL CODIGO","text":"Debe ingresar el codigo del empleado que desea agregar a la planilla."}});
      return true;
    }
    coddag=numCoddag.value;
    nomdag=txtNomdag.value;  

    const parametros = new FormData();
    parametros.append("action", "guardarAg");
    parametros.append("numNum", numNum.value);
    parametros.append("dtDel", dtDel.value);
    parametros.append("dtAl", dtAl.value);
    parametros.append("numCoddag", numCoddag.value);
    parametros.append("txtNomdag", txtNomdag.value);
    
    $.ajax({
      data:  parametros,
      url:   window.location.origin+window.location.pathname+"actions.php",
      type:  "post",
      contentType: false,
      processData: false,
      async: true,
      //beforeSend: function () {
        //alLoad("Cargando...")
      //},
      success: function (jsonPhp) {
        console.log(jsonPhp);
        const jsonJS = JSON.parse(jsonPhp);
        if(jsonJS.error==true){
          alError(jsonJS);
        } else {
          if (isNullPer(jsonJS.puesto)) {
            puesto="";
          } else {
            puesto=jsonJS.puesto;
          }
          totdev=jsonJS.totdev;
          totdes=jsonJS.totdes;
          liqrec=jsonJS.liqrec;
          addRowNomper(coddag, nomdag, puesto, Number(totdev).toFixed(2), Number(totdes).toFixed(2), Number(liqrec).toFixed(2));
          $('#modalNomperag').modal('toggle');
        }
      }
    });
  });

  // CLICK Cancelar el agregado
  $("#btnCancelarag").click(function (){
    $('#modalNomperag').modal('toggle');
  });

  // CLICK DEL
  $("body").on("click", "#btnDel", function() {
    const row = $(this).parents("tr");

    const dataCod = $(this).parents("tr").find("#dataCod");
    numCoddm.value = dataCod.text();
    borrarReg();

    alDelete(function fn(){
      row.remove();
      sumDetao();
    });
  });

  // CLICK EDIT
  $("body").on("click", "#btnEdit", function() {
    $('#pills-00-tab').text("MODIFICAR PLANILLA No. "+numNum.value);
    $('#btnAgregar').hide();
    $('#btnModificar').show();

    numDtradm.focus();

    const dataCod = $(this).parents("tr").find("#dataCod");
    const dataNom = $(this).parents("tr").find("#dataNom");
  //  const dataPuesto = $(this).parents("tr").find("#dataPuesto");
    const dataTotdev = $(this).parents("tr").find("#dataTotdev");
    const dataTotdes = $(this).parents("tr").find("#dataTotdes");
    const dataLiqrec = $(this).parents("tr").find("#dataLiqrec");

    numCoddm.value = dataCod.text();
    txtNomdm.value = dataNom.text();
  //  txtPuestodm.value = dataPuesto.text();
    numTotdevdm.value = dataTotdev.text();
    numTotdesdm.value = dataTotdes.text();
    numLiqrecdm.value = dataLiqrec.text();

    consultarNp();

    $("body").on("click", "#btnModificar", function() {
      if ((Number(numDtradm.value)+Number(numDseptdm.value)+Number(numDferidm.value)+Number(numDsusidm.value)+Number(numDvacadm.value))>15) {
        //numDtradm.focus();
        alWarning({"msg":{"title":"SUPERO LOS DIAS PERMITIDOS","text":"No puede registrar más de 15 dias, revise."}});
        return true;
      } 

      $('#modalNomper').modal('toggle');

      dataCod.text(numCoddm.value);
      dataNom.text(txtNomdm.value);
    //  dataPuesto.text(txtPuestodm.value);
      dataTotdev.text(isNullNumber(numTotdevdm.value).toFixed(2));
      dataTotdes.text(isNullNumber(numTotdesdm.value).toFixed(2));
      dataLiqrec.text(isNullNumber(numLiqrecdm.value).toFixed(2));

      guardarNp();

      limpiarModalNomper();
      sumDetao();
    });
  });

  // MODALDetao HIDDEN
  $('#modalNomper').on('hidden.bs.modal', function (e) {
    $("body").off("click", "#btnModificar");
  });


  // FOCUS PILL
  $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
    if (!isMobile()) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;

      if (target != "#pills-0") {
        $(target+' input:visible:first').focus();
      } else {
        (relatedTarget == "#pills-00") ? numDtradm.focus() : 0;
        (relatedTarget == "#pills-000") ? numCoddag.focus() : 0;
      }
    }
  });

</script>

