<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$numNum=$_GET["numNum"];
$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];

# QUERYS
$sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom,
                mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                WHERE np_emp='$empCod' AND np_numpla='$numNum' ORDER BY np_emp,np_gru,np_dep,np_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['planilla']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "Planilla No. ".$numNum)

            ->setCellValueByColumnAndRow($i, 3, "Correspondiente del ".strftime("%d/%m/%Y", strtotime($dtDel))." al ".strftime("%d/%m/%Y", strtotime($dtAl)))
            ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
            ->setCellValueByColumnAndRow($i++, $j, 'NOMBRE')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO ORDINARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'HORAS EXTRAS')
            ->setCellValueByColumnAndRow($i++, $j, 'BONIFICACION LEY')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL DEVENGADO')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'ISR')
            ->setCellValueByColumnAndRow($i++, $j, 'ANTICIPO')
            ->setCellValueByColumnAndRow($i++, $j, 'DESCUENTOS VARIOS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL DESCUENTOS')
            ->setCellValueByColumnAndRow($i++, $j, 'LIQUIDO RECIBIR');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    )
 /*,   'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    ) */
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') )
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A5:L5')->applyFromArray($styEncabezado);
$totdepo=0;
$totch=0;
$grupop=99999;
$depp=99999;
$t_lini=1;
$j=6;
$inidep=6;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    if (($rec["mae_gru"].$rec["mae_dep"]) != ($grupop.$depp)) {
        if ($t_lini>1) {
           $i=$iIni;
           $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(C'.$inidep.':C'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidep.':D'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidep.':E'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidep.':F'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidep.':G'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(H'.$inidep.':H'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(I'.$inidep.':I'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('B'.$j.':L'.$j)->applyFromArray($styTotales);
            $j+=1;
            $inidep=$j;
        }

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, "GRUPO Y DEPARTAMENTO: ".$rec["gru_nom"].", ".$rec["dep_nom"]);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':E'.$j)->applyFromArray($styEmp);

        $grupop=$rec["mae_gru"];
        $depp=$rec["mae_dep"];
        $j+=1;
        $t_lini=2;
    }
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_cod"])
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode($rec["mae_nom"]." ".$rec["mae_ape"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sord"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sexts"]+$rec["np_sextd"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_comi"]+$rec["np_otrp"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_totdev"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_igss"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_isr"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_anti"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_totdes"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_liqrec"]); 
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':L'.$j)->applyFromArray($styLineas);
    $j+=1;
    if ($rec["mae_fpago"]<=2) {
        $totdepo+=$rec["np_liqrec"];
    } else {
        $totch+=$rec["np_liqrec"];
    }
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(C'.$inidep.':C'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(D'.$inidep.':D'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidep.':E'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidep.':F'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidep.':G'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(H'.$inidep.':H'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(I'.$inidep.':I'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')');
    $objPHPExcel->getActiveSheet()->getStyle('B'.$j.':L'.$j)->applyFromArray($styTotales);
$j+=1;
$inidep=$j;

$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "                          TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",C6:C'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",D6:D'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",E6:E'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",F6:F'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",G6:G'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",H6:H'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",I6:I'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",J6:J'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",K6:K'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",L6:L'.($j-1).')') ;
$objPHPExcel->getActiveSheet()->getStyle('B'.$j.':L'.$j)->applyFromArray($styTotales);

$j+=1;
$i=$iIni;
/*
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "DEPOSITO A CUENTA")
    ->setCellValueByColumnAndRow($i++, $j, $totdepo);
$j+=1;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "PAGO CON CHEQUE")
    ->setCellValueByColumnAndRow($i++, $j, $totch);

$j+=4;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "Hecho por: ___________________________________")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "Revisado por: ___________________________________")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "Autorizado por: ___________________________________");
$j+=1;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "                                    Recursos Humanos        ")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "                                      Contabilidad               ")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "");
*/

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(50);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

$objPHPExcel->getActiveSheet()->getStyle('C6'.':L'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':B'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])->setTitle('Planilla Final');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Planilla_Final.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>