<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

global $empCod, $usuNom, $bitMod, $bitForm, $selBan, $dtFec, $numNum, $Banctab, $Banctac, $txtCodp, $txtNomp;

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

$numAno=$_GET["numAno"];
//$selBan=$_GET["selBan"];
//$Banctab=$_GET["Banctab"];
//$Banctac=$_GET["Banctac"];
//$dtFec=$_GET["dtFec"];

$lineWidth=19;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec, $numAno, $txtCodp, $txtNomp, $Banctab;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO PARA ACREDICACION A CUENTAS FECHA DEL REPORTE: ".strftime("%d/%m/%Y")),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "BONO 14 CORRESPONDIENTE A: ".$numAno,0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "CUENTA BANCARIA: ".$Banctab,0,1,"L");

        $this->Ln();
        $this->SetFont("","",9);
        $header = array("CUENTA","NOMBRE","MONTO");
        $this->SetFont("","B");
        $this->SetWidths(array(5,10,3));
        $this->SetAligns(array("C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sBono14 = "SELECT b14.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
            TRIM(mae.mae_nomch) AS mae_nomch, TRIM(mae.mae_ctab) AS mae_ctab, TRIM(tpu.tpu_nom) AS tpu_nom
            FROM bono14 b14
            LEFT JOIN maestro mae ON b14.b14_emp=mae.mae_emp AND b14.b14_cod = mae.mae_cod 
            LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
            WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND mae_fpago<3";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["bono14"] = $db->query($sBono14);
$totpag=0;
# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();

while ($rec = $db->fetchAssoc($select["bono14"])) {
    $body = array(
        $rec["mae_ctab"],
        trim($rec["mae_nomch"]),
        number_format($rec["b14_liqrec"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $totpag+=$rec["b14_liqrec"];
}
$pdf->line($pdf->GetX()+9, $pdf->GetY(), 19.5, $pdf->GetY());
$body = array(
    "",
    "                                                TOTAL",        
    number_format($totpag, 2, '.', ','),        
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->Output(utf8_decode("ListaAcreditacionB14").".pdf","I");
$db->close();
?>