<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "nom3120";
$bitMod = "nom";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultarPla':
		echo consultarPla();
		break;
	case 'consultarNp':
		echo consultarNp();
		break;

	case 'consultarEmple':
		echo consultarEmple();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'guardarAg':
		echo guardarAg();
		break;

	case 'borrar':
		echo borrar();
		break;

	case 'borrarReg':
		echo borrarReg();
		break;

}

function consultarPla() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];

	# QUERYS

	$sAguinal = "SELECT agui.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom 
				FROM aguinal agui
 				LEFT JOIN maestro mae ON agui.agui_emp=mae.mae_emp AND agui.agui_cod = mae.mae_cod 
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE agui_emp='$empCod' AND agui_ano='$numAno'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["aguinal"] = $db->sFetchAll($sAguinal);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'aguinal');
}

function consultarNp() {
	global $empCod, $usuNom;

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];

	# QUERYS

	$sAguinal = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom
				FROM aguinal agui
 				LEFT JOIN maestro mae ON agui.agui_cod = mae.mae_cod 
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$numCod'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["aguinal"] = $db->sFetchAssoc($sAguinal);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'aguinal');
}

function consultarEmple() {
	global $empCod, $usuNom;

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCoddag=$_POST['numCoddag'];

	# QUERYS

	$sMaestro = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom
				FROM maestro mae
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE mae_emp ='$empCod' AND mae_cod='$numCoddag'";

	$sAguinal = "SELECT *
				FROM aguinal
				WHERE agui_emp ='$empCod' AND agui_ano='$numAno' AND agui_cod='$numCoddag'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sAguinal, "aguinal");
	$resp["maestro"] = $db->sFetchAssoc($sMaestro);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'aguinal', 'maestro');
}


function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];
	$numEne=(empty($_POST['numEne'])) ? 0 : $_POST['numEne'];
	$numFeb=(empty($_POST['numFeb'])) ? 0 : $_POST['numFeb'];
	$numMar=(empty($_POST['numMar'])) ? 0 : $_POST['numMar'];
	$numAbr=(empty($_POST['numAbr'])) ? 0 : $_POST['numAbr'];
	$numMay=(empty($_POST['numMay'])) ? 0 : $_POST['numMay'];
	$numJun=(empty($_POST['numJun'])) ? 0 : $_POST['numJun'];
	$numJul=(empty($_POST['numJul'])) ? 0 : $_POST['numJul'];
	$numAgo=(empty($_POST['numAgo'])) ? 0 : $_POST['numAgo'];
	$numSep=(empty($_POST['numSep'])) ? 0 : $_POST['numSep'];
	$numOct=(empty($_POST['numOct'])) ? 0 : $_POST['numOct'];
    $numNov=(empty($_POST['numNov'])) ? 0 : $_POST['numNov'];
	$numDic=(empty($_POST['numDic'])) ? 0 : $_POST['numDic'];
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];
	$numAnti=(empty($_POST['numAnti'])) ? 0 : $_POST['numAnti'];
	$numAgui=(empty($_POST['numAgui'])) ? 0 : $_POST['numAgui'];
	$numLiqrec=(empty($_POST['numLiqrec'])) ? 0 : $_POST['numLiqrec'];

	# QUERYS PARA UN REGISTRO
	$uAguinal="UPDATE aguinal SET agui_ene='$numEne', agui_feb='$numFeb', agui_mar='$numMar', agui_abr='$numAbr', agui_may='$numMay', agui_jun='$numJun', agui_jul='$numJul', agui_ago='$numAgo', agui_sep='$numSep', agui_oct='$numOct', agui_nov='$numNov', agui_dic='$numDic', agui_tot='$numTot', agui_anti='$numAnti', agui_agui='$numAgui', agui_liqrec='$numLiqrec'  WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$numCod'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp= $db->uEx($uAguinal);
	$db->iEx($func->iBitacora(utf8_decode("Se Modifico El Aguinaldo Año $numAno  Codigo: $numCod Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();
	
	return json_encode($resp);
}


function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];

	# QUERYS PARA UN REGISTRO

	$dAguinal="DELETE FROM aguinal WHERE agui_emp='$empCod' AND agui_ano='$numAno'";

	# QUERYS PARA VARIOS REGISTROS

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dAguinal);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro El Aguinaldo Año: $numAno Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function borrarReg() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];


	# QUERYS PARA UN REGISTRO

	$dAguinal="DELETE FROM aguinal WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$numCod'";
	
	# QUERYS PARA VARIOS REGISTROS

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dAguinal);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro Codigo: $numCod del Aguinaldo Año: $numAno Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function guardarAg() {
	global $empCod, $usuNom, $bitMod, $bitForm, $numAno, $numCoddag, $dtDel, $dtAl, $mes, $ano;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCoddag=$_POST['numCoddag'];
	$txtNomdag=$_POST['txtNomdag'];

	$anoant=$numAno-1;
	$fecini1=$anoant."-07-01";
	$fecfin1=$numAno."-06-30";
	$fini = date("Y-m-d", strtotime($fecini1));
	$ffin = date("Y-m-d", strtotime($fecfin1));

	# QUERYS PARA UN REGISTRO
	$sNomper = "SELECT np.*, mae.mae_cod, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
			mae_fing, TRIM(pue.tpu_nom) AS tpu_nom
			FROM nomper np
			LEFT JOIN maestro mae ON mae.mae_emp=np.np_emp AND mae.mae_cod=np.np_cod 
			LEFT JOIN tpuesto pue ON mae.mae_tpue=pue.tpu_cod
			WHERE np_emp='$empCod' AND np_ffin>='$fini' AND np_ffin<='$ffin' AND np_cod='$numCoddag'";

	$dAguinal = "DELETE FROM aguinal WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$numCoddag'";

	function iAguinal($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$agui,$fing) { 
		global $empCod, $usuNom,  $numAno;
		return "INSERT INTO aguinal(agui_emp, agui_ano, agui_cod, agui_ene, agui_feb, agui_mar, agui_abr, agui_may, agui_jun, agui_jul, agui_ago, agui_sep, agui_oct, agui_nov, agui_dic, agui_tot, agui_agui, agui_liqrec, agui_fing) VALUES ('$empCod', '$numAno','$cod','$ene','$feb','$mar', $abr,'$may','$jun','$jul','$ago','$sep','$oct','$nov','$dic','$tot','$agui','$agui', '$fing')";
	}
	function uAguinal($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$agui) { 
		global $empCod, $usuNom,  $numAno;
		return "UPDATE aguinal SET agui_ene='$ene', agui_feb='$feb', agui_mar='$mar', agui_abr='$abr', agui_may='$may', agui_jun='$jun', agui_jul='$jul', agui_ago='$ago', agui_sep='$sep', agui_oct='$oct', agui_nov='$nov', agui_dic='$dic', agui_tot='$tot', agui_agui='$agui', agui_liqrec='$agui' WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$cod'";
	}
	function sAguinal($cod) { 
		global $empCod, $usuNom,  $numAno;
		return "SELECT * FROM aguinal WHERE agui_emp='$empCod' AND agui_ano='$numAno' AND agui_cod='$cod'";
	}


	# EJECUCION DE QUERYS 
	$db = new dbExec();
    $resp = $db->dEx($dAguinal);
    $puesto="";
    $totagui=0;
    $liqrec=0;
	$select["nomper"] = $db->query($sNomper);
	while ($rec = $db->fetchAssoc($select['nomper'])) {
	    $cod = $rec["np_cod"];
	    $fing = $rec["mae_fing"];
	    $fecha = $rec["np_ffin"];
        $puesto= $rec["tpu_nom"];
	    $sdia = round($rec["np_snom"]/30,6);
	    $svaca=0;
	    $ssusi=0;
	    if ($rec["np_dvaca"]>0) {
	       $svaca= round($rec["np_dvaca"]*$sdia,2);
	    }
	    if ($rec["np_dsusi"]>0) {
		   $ssusi= round($rec["np_dsusi"]*$sdia,2);
	    }
	    $mesnp= date("m", strtotime($fecha));
	    $ene=0;
	    $feb=0;
	    $mar=0;
	    $abr=0;
	    $may=0;
	    $jun=0;
	    $jul=0;
	    $ago=0;
	    $sep=0;
	    $oct=0;
	    $nov=0;
	    $dic=0;

	    switch ($mesnp){
	      case 1:
	        $ene = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 2:
	        $feb = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 3:
	        $mar = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 4:
	        $abr = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 5:
	        $may = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 6:
	        $jun = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 7:
	        $jul = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 8:
	        $ago = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 9:
	        $sep = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 10:
	        $oct = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 11:
	        $nov = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 12:
	        $dic = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	    }

		$select["aguinal"] = $db->query(sAguinal($cod));
		$fetchAssoc["aguinal"] = $db->fetchAssoc($select["aguinal"]);
		if ($db->numRows($select["aguinal"]) == 0) {
		   $tot=($ene+$feb+$mar+$abr+$may+$jun+$jul+$ago+$sep+$oct+$nov+$dic);
		   if ($tot>0) {
		      $agui=round($tot/12,2);
		   } else {
		   	  $agui=0;
		   }
		   $totagui=$agui;
		   $liqrec=$agui;
	       $db->iEx(iAguinal($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$agui,$fing));
	       continue;
		} else {
		   $nuene=$fetchAssoc["aguinal"]["agui_ene"]+$ene;
		   $nufeb=$fetchAssoc["aguinal"]["agui_feb"]+$feb;
		   $numar=$fetchAssoc["aguinal"]["agui_mar"]+$mar;
		   $nuabr=$fetchAssoc["aguinal"]["agui_abr"]+$abr;
		   $numay=$fetchAssoc["aguinal"]["agui_may"]+$may;
		   $nujun=$fetchAssoc["aguinal"]["agui_jun"]+$jun;
		   $nujul=$fetchAssoc["aguinal"]["agui_jul"]+$jul;
		   $nuago=$fetchAssoc["aguinal"]["agui_ago"]+$ago;
		   $nusep=$fetchAssoc["aguinal"]["agui_sep"]+$sep;
		   $nuoct=$fetchAssoc["aguinal"]["agui_oct"]+$oct;
		   $nunov=$fetchAssoc["aguinal"]["agui_nov"]+$nov;
		   $nudic=$fetchAssoc["aguinal"]["agui_dic"]+$dic;
		   $tot=($nuene+$nufeb+$numar+$nuabr+$numay+$nujun+$nujul+$nuago+$nusep+$nuoct+$nunov+$nudic);
		   if ($tot>0) {
		      $agui=round($tot/12,2);
		   } else {
		   	  $agui=0;
		   }
		   $totagui=$agui;
		   $liqrec=$agui;
	       $db->uEx(uAguinal($cod,$nuene,$nufeb,$numar,$nuabr,$numay,$nujun,$nujul,$nuago,$nusep,$nuoct,$nunov,$nudic,$tot,$agui));
		}
	}

	$db->iEx($func->iBitacora(utf8_decode("Se Genero Aguinaldo:  $numAno Codigo: $numCoddag   Usuario: ").$usuNom, $bitMod, $bitForm));

	$resp["puesto"] = $puesto;
	$resp["totagui"] = $totagui;
	$resp["totanti"] = 0;
	$resp["liqrec"] = $liqrec;
	$db->close();
	return json_encode($resp);
}


?>