<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numAno=$_GET["numAno"];
$dtFec=$_GET["dtFec"];

$lineWidth=19;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sAguinal = "SELECT agui.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, mae_fing, TRIM(mae.mae_dpi) AS mae_dpi, 
            TRIM(tpu.tpu_nom) AS tpu_nom
            FROM aguinal agui
            LEFT JOIN maestro mae ON agui.agui_emp=mae.mae_emp AND agui.agui_cod = mae.mae_cod 
            LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
            WHERE agui_emp='$empCod' AND agui_ano='$numAno'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["aguinal"] = $db->query($sAguinal);
$db->close();

# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();
$ti_clasi="XXX";
while ($rec = $db->fetchAssoc($select["aguinal"])) {
    $lineHeight=0.5;
    $pdf->SetFont("ARIAL","B",16);
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("RECIBO DE PAGO AGUINALDO"),0,1,"C");
    //.strftime("%d/%m/%Y")),0,1,"L");
    $pdf->Ln();
    $pdf->SetFont("","",10);
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("RECIBI DE: ").$empNom,0,1,"L");
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LA CANTIDAD DE: ------ Q. ").number_format($rec["agui_liqrec"], 2, '.', ',')." ----",0,1,"L");
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("POR: Pago Correpondiente al Aguinaldo del  año: ").$numAno,0,1,"L");
    //$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
    $pdf->SetFont("","B",10);
    $lineHeight=0.62;
    $pdf->Ln();
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("Fecha de ingreso:  "),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["mae_fing"])),0,1,"L");
    $pdf->Ln();
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("Aguinaldo: "),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/7, $lineHeight, number_format($rec["agui_agui"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("Anticipo: "),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/7, $lineHeight, number_format($rec["agui_anti"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("LIQUIDO A RECIBIR: "),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/7, $lineHeight, number_format($rec["agui_liqrec"], 2, '.', ','),1,1,"R");
    $pdf->Ln(1);
    $pdf->line($pdf->GetX()+0, $pdf->GetY(), 19, $pdf->GetY());    
    $pdf->SetFont("","",8);
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Fecha de Emisión:  ").strftime("%d/%m/%Y", strtotime($dtFec)),0,1,"L");
    $pdf->Ln(3);
    $pdf->SetFont("","",9);
    $pdf->line($pdf->GetX()+6, $pdf->GetY(), 17, $pdf->GetY());
    $lineHeight=0.40;
    $pdf->MultiAlignCell($lineWidth/3, $lineHeight, " ",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, $rec["agui_cod"]." - ".$rec["mae_nom"]." ".$rec["mae_ape"],0,1,"C");
    $pdf->MultiAlignCell($lineWidth/3, $lineHeight, " ",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight, "DPI: ".$rec["mae_dpi"],0,1,"C");
    $pdf->Ln(1);

    //La linea de abajo se desbloquea, si se puede configurar media carta en la impresora que usen
//    $pdf->AddPage();
}
$pdf->Output(utf8_decode("RecibosAguinaldo").".pdf","I");
?>