<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empDir=utf8_decode($_SESSION["empDir"]);
$empTelpat=utf8_decode($_SESSION["empTelpat"]);

$numNum=$_GET["numNum"];
$numCoddm=(empty($_GET['numCoddm'])) ? 0 : $_GET['numCoddm'];
$dtFec=$_GET["dtFec"];

$lineWidth=18;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $lineWidth, $lineHeight, $empNom;
        $this->SetMargins(2, 1, 2);
        $this->SetFont("Arial","B",10);
        $this->Ln(1);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"L");
        $this->Cell(0,0, utf8_decode("Recibo No. ".((string)($this->PageNo())))."                  ",0,1,"R");
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($numCoddm==0) {
    $sNomper = "SELECT np.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(mae.mae_dpi) AS mae_dpi,
                TRIM(tpu.tpu_nom) AS tpu_nom, TRIM(mes.mes_nom) AS mes_nom, DAY(np.np_fini) AS diaini,
                DAY(np.np_ffin) AS diafin, YEAR(np.np_ffin) AS anofin
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN meses mes ON month(np.np_fini) = mes.mes_cod 
                WHERE np_emp='$empCod' AND np_numpla='$numNum'";
} else {
    $sNomper = "SELECT np.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(mae.mae_dpi) AS mae_dpi,
                TRIM(tpu.tpu_nom) AS tpu_nom, TRIM(mes.mes_nom) AS mes_nom, DAY(np.np_fini) AS diaini,
                DAY(np.np_ffin) AS diafin, YEAR(np.np_ffin) AS anofin
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN meses mes ON month(np.np_fini) = mes.mes_cod 
                WHERE np_emp='$empCod' AND np_numpla='$numNum'  AND np_cod='$numCoddm'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);
$db->close();

# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$pdf->SetMargins(2, 1, 2);
$func = new functions();
$img = '../img/LOGO_COAMCO.JPEG';
if ($empCod=='01 ') {
   $img = '../img/LOGO_COAMCO.JPEG';
}
if ($empCod=='02 ') {
   $img = '../img/LOGO_PROGEYCO.JPEG';
}
if ($empCod=='02 ') {
   $img = '../img/LOGO_DHC.JPEG';
}
//$pdf->Image($img,12,6,8,2);
//$pdf->SetMargins(1.5, 1, 1);
//$pdf->SetY(4.50);
$t_corr=1;
$ti_clasi="XXX";
while ($rec = $db->fetchAssoc($select["nomper"])) {
//    $pdf->SetMargins(2, 1, 2);
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("BOLETA DE PAGO"),0,1,"C");
    $pdf->Ln();
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("CORRESPONDIENTE AL PERIODO DE: "),0,0,"L");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("Del  ").$rec["diaini"]."  al  ".$rec["diafin"]." de ".$rec["mes_nom"]." de ".$rec["anofin"].".",0,1,"L");
    //$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("Días Laborados: "),0,0,"L");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, number_format($rec["np_dtra"], 2, '.', ','),0,1,"L");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("Empleado: "),0,0,"L");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, $rec["mae_nom"].$rec["mae_ape"],0,1,"L");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("Puesto: "),0,0,"L");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, $rec["tpu_nom"],0,1,"L");

    $pdf->Ln();
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/5.5, $lineHeight, utf8_decode("HORAS EXTRAS: "),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/6, $lineHeight, number_format($rec["np_hsim"]+$rec["np_hdob"], 2, '.', ','),0,1,"L");

    $pdf->SetFont("Arial","BU",9);
    $pdf->MultiAlignCell($lineWidth/3.5, $lineHeight, utf8_decode(" INGRESOS "),0,1,"C");
    $lineHeight=0.60;
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) SALARIO MENSUAL"),0,0,"L");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_sord"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Bonificacion por Desempeño"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_bonii"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Depreciación Vehiculo"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_depre"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Isr Devolución"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_isrdevo"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Viaticos"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_viati"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Bonificación Dto. 78-89"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_boni"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Horas Extras"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_sexts"]+$rec["np_sextd"], 2, '.', ','),0,0,"R");
    //$pdf->MultiAlignCell($lineWidth/12, $lineHeight, "",0,0,"L");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/4.8, $lineHeight, utf8_decode("    RECIBí CONFORME:"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "________________________",0,1,"L");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (+) Otros Ingresos"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_bonoe"]+$rec["np_comi"]+$rec["np_otrp"], 2, '.', ','),0,0,"R");
    $pdf->MultiAlignCell($lineWidth/4.8, $lineHeight, "",0,0,"L");
    $pdf->SetFont("Arial","B",7);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $rec["mae_nom"]." ".$rec["mae_ape"],0,1,"C");

    $pdf->line($pdf->GetX()+6, $pdf->GetY(), 12, $pdf->GetY());    
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("      TOTAL DEVENGADO"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_totdev"], 2, '.', ','),0,0,"R");
    $pdf->MultiAlignCell($lineWidth/8.8, $lineHeight,"",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/10.8, $lineHeight," DPI",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $rec["mae_dpi"],0,1,"C");

    $pdf->Ln();
    $pdf->SetFont("Arial","BU",9);
    $pdf->MultiAlignCell($lineWidth/3.5, $lineHeight, utf8_decode(" DESCUENTOS "),0,1,"C");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (-) IGSS"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_igss"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (-) DESCUENTOS JUDICIALES"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_desj"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (-) ISR"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_isr"], 2, '.', ','),0,1,"R");

    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (-) ANTICIPOS"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_anti"], 2, '.', ','),0,0,"R");
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/4.8, $lineHeight,"                        Vo. Bo.",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "________________________",0,1,"L");
    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("  (-) OTROS DESCUENTOS"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_preb"]+$rec["np_pree"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_otrd"], 2, '.', ','),0,0,"R");
    $pdf->SetFont("Arial","B",7);
    $pdf->MultiAlignCell($lineWidth/4.8, $lineHeight,"",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("Hugo René Lopez Barrientos "),0,1,"C");
    $pdf->SetFont("Arial","B",9);

    $pdf->line($pdf->GetX()+6, $pdf->GetY(), 12, $pdf->GetY());    
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("      TOTAL DE DESCUENTOS"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode("Q"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, number_format($rec["np_totdes"], 2, '.', ','),0,0,"R");
    $pdf->MultiAlignCell($lineWidth/8.8, $lineHeight,"",0,0,"L");
    $pdf->MultiAlignCell($lineWidth/10.8, $lineHeight,"",0,0,"L");
    $pdf->SetFont("Arial","",8);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Jefe de Recursos Humanos",0,1,"C");

    $pdf->Ln(1);
    $pdf->line($pdf->GetX()+6, $pdf->GetY(), 12, $pdf->GetY());    
    $pdf->SetFont("Arial","B",9);
    $pdf->MultiAlignCell($lineWidth/2.8, $lineHeight, utf8_decode("      SALARIO LIQUIDO A RECIBIR"),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/12, $lineHeight, utf8_decode(""),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/9, $lineHeight, "Q".number_format($rec["np_liqrec"], 2, '.', ','),0,1,"R");
    $pdf->line($pdf->GetX()+6, $pdf->GetY(), 12, $pdf->GetY());    
    $pdf->line($pdf->GetX()+6, $pdf->GetY()+.1, 12, $pdf->GetY()+.1);  
    $pdf->Ln(1);

    $pdf->SetFont("Arial","",9);
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, $empDir,0,1,"C");
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, "GUATEMALA, GUATEMALA TEL. ".$empTelpat,0,1,"C");
    $pdf->Ln(8);
    if ($t_corr==1) {
        $pdf->Rect(1.7, 1.5, 18.3, 19);
        $pdf->Image($img,11.9,5.4,8,2);
    } else {
        $pdf->Rect(1.7, 1.5, 18.3, 21);
        $pdf->Image($img,11.9,7.2,8,2);
    }
    $t_corr=2;
 //   $pdf->AddPage();

    //La linea de abajo se desbloquea, si se puede configurar media carta en la impresora que usen
//    $pdf->AddPage();
}
$pdf->Output(utf8_decode("Recibos").".pdf","I");
?>